﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testCapsrv_TargetImageRenderer.h"

#include <nn/nn_Abort.h>
#include <nn/vi/vi_ProxyName.private.h>

namespace nnt{ namespace capsrv{

    TargetImageRenderer::TargetImageRenderer() NN_NOEXCEPT
        : m_IsInitialized(false)
        , m_pDisplay()
        , m_pLayer()
    {
    }

    TargetImageRenderer::~TargetImageRenderer() NN_NOEXCEPT
    {
        if(m_IsInitialized)
        {
            FinalizeImpl();
        }
    }

    void TargetImageRenderer::Initialize() NN_NOEXCEPT
    {
        if(m_IsInitialized)
        {
            return;
        }

        nn::vi::SetRelayProxyName("imgrndr");
        nn::vi::Initialize();

        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&m_pDisplay));
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::CreateLayer(&m_pLayer, m_pDisplay));

        // 出画キュー
        {
            nn::vi::buffer::BufferInfo info;
            info.bufferCount = BufferCount;
            info.width = Width;
            info.height = Height;
            info.format = Format;
            NN_ABORT_UNLESS_RESULT_SUCCESS(m_Queue.Initialize(m_pLayer, info));
        }
        // 出画バッファ
        for(int i = 0; i < BufferCount; i++)
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(m_Queue.SetScanBuffer(i, m_Memory[i], sizeof(m_Memory[i])));
        }

        m_IsInitialized = true;
    }

    void TargetImageRenderer::Finalize() NN_NOEXCEPT
    {
        // デストラクタで Finalize する
    }

    void TargetImageRenderer::FinalizeImpl() NN_NOEXCEPT
    {
        m_Queue.Finalize();
        nn::vi::Finalize();
    }

    void TargetImageRenderer::Present(const void* pData, size_t size) NN_NOEXCEPT
    {
        nn::vi::buffer::BufferQueueHandle* pHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(m_Queue.DequeueBuffer(&pHandle));

        void* pAddress = nullptr;
        NN_ABORT_UNLESS_RESULT_SUCCESS(m_Queue.GetScanBufferAddress(&pAddress, pHandle));

        std::memcpy(pAddress, pData, size);
        NN_ABORT_UNLESS_RESULT_SUCCESS(m_Queue.QueueBuffer(pHandle));
    }

}}

