﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <random>
#include <memory>
#include <nn/nn_Common.h>
#include <nn/image/image_Common.h>

#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/capsrv/capsrv_ScreenShotOrientation.h>

namespace nnt{ namespace capsrv{

    enum TestFileSignaturePattern
    {
        // 有効な署名
        TestFileSignaturePattern_Valid,
        // ゼロ詰めされた署名
        TestFileSignaturePattern_Zero,
        // 有効な署名の先頭ビットを反転した署名
        TestFileSignaturePattern_HeadBitFlip,
        // 有効な署名の末尾ビットを反転した署名
        TestFileSignaturePattern_TailBitFlip,
    };

    struct TestRawImage
    {
    public:
        nn::image::Dimension GetDimension() const NN_NOEXCEPT
        {
            nn::image::Dimension dim = {this->width, this->height};
            return dim;
        }
    public:
        int width;
        int height;
        std::vector<uint8_t> data;
    };

    struct TestScreenShotFileMetaData
    {
        nn::ncm::ApplicationId applicationId;
        nn::capsrv::AlbumFileDateTime time;
        nn::capsrv::ScreenShotOrientationType orientation;
    };


    class TestFileUtility
    {
    public:
        // @brief ランダムな画像の生データを生成します。
        // @param[in] width 幅
        // @param[in] height 高さ
        // @param[in] blockSize ブロックの大きさ（ピクセル）
        // @param[in] engine 乱数生成器
        // @details
        // RGBがランダムな画像が作成されます。Aは255固定です。
        // 正方形の単色のブロックが並べられた画像が生成されます。
        static TestRawImage CreateRawImageDataRgba32(int width, int height, int blockSize, std::mt19937& engine) NN_NOEXCEPT;

        // @brief 生画像同士の比較を行います
        // @details
        //   画素値の差の合計を返します。
        static uint64_t CompareRawImageDataRgba32(const TestRawImage& a, const TestRawImage& b) NN_NOEXCEPT;

        // @brief 生画像データにメタデータを付加した JPEG を作成します。
        static std::vector<uint8_t> CreateScreenShotFileData(const TestRawImage& raw, const TestScreenShotFileMetaData& meta, TestFileSignaturePattern signaturePattern) NN_NOEXCEPT;

        // @brief JPEG をデコードして生画像を返します。
        static TestRawImage DecodeJpeg(const std::vector<uint8_t>& jpeg) NN_NOEXCEPT;

    };

}}
