﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined(NNT_CAPSRV_ENABLE_LOCAL_HIPC)

#include "testCapsrv_Server.h"

#include <cstdlib>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>

#include "testCapsrv_AlignedAllocate.h"

namespace nn{ namespace capsrv{ namespace server{
    void InitializeServerObject() NN_NOEXCEPT;
    void FinalizeServerObject() NN_NOEXCEPT;

    void InitializeServerManager() NN_NOEXCEPT;
    void FinalizeServerManager() NN_NOEXCEPT;
    void RunServerManager() NN_NOEXCEPT;
    void RequestStopServerManager() NN_NOEXCEPT;
}}}

namespace nnt{ namespace capsrv{

    namespace {
        static const size_t StackSize = nn::os::ThreadStackAlignment * 16;

        nn::os::ThreadType g_ServerThread;
        void* g_pServerStack;
        nn::mem::StandardAllocator* g_pAllocator;

        void ServerThreadFunction(void*) NN_NOEXCEPT
        {
            nn::capsrv::server::RunServerManager();
        }

    }


    void StartServer(nn::mem::StandardAllocator* pAllocator) NN_NOEXCEPT
    {
        nn::capsrv::server::InitializeServerObject();
        nn::capsrv::server::InitializeServerManager();

        g_pServerStack = AlignedAllocate(pAllocator, StackSize, nn::os::ThreadStackAlignment);
        NN_ASSERT_NOT_NULL(g_pServerStack);
        g_pAllocator = pAllocator;

        nn::Result result;
        result = nn::os::CreateThread(
            &g_ServerThread,
            ServerThreadFunction,
            nullptr,
            g_pServerStack,
            StackSize,
            nn::os::DefaultThreadPriority,
            2
            );
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        nn::os::StartThread(&g_ServerThread);
    }

    void StopServer() NN_NOEXCEPT
    {
        nn::capsrv::server::RequestStopServerManager();
        nn::os::WaitThread(&g_ServerThread);
        nn::os::DestroyThread(&g_ServerThread);
        AlignedFree(g_pAllocator, g_pServerStack);
        nn::capsrv::server::FinalizeServerManager();
        nn::capsrv::server::FinalizeServerObject();
    }


}}

#endif
