﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <string>

#include <nn/nn_Common.h>

#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/capsrv/capsrv_AlbumStorage.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>
#include <nn/capsrv/capsrv_AlbumFileDateTime.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>

namespace nnt{ namespace capsrv{

    class DirectAlbumAccessor
    {
    public:
        static const int PathSize = 128;

    public:
        static void MountAllStorages() NN_NOEXCEPT;
        static void UnmountAllStorages() NN_NOEXCEPT;

        static bool IsMounted(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;

        static bool CleanupAlbum(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        static bool CleanupAllAlbums() NN_NOEXCEPT;

        static const char* GetRootPath(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;

        // @brief ファイルパスを作成します。
        static void GetFilePath(
            char* pOutBuffer,
            size_t bufferSize,
            nn::capsrv::AlbumStorageType storage,
            const nn::capsrv::AlbumFileDateTime& time,
            nn::ncm::ApplicationId appId,
            nn::capsrv::AlbumFileContentsType contents
            ) NN_NOEXCEPT;

        static void GetSubDirectoryPath(
            int* pOutLength,
            char* pBuffer,
            size_t bufferSize,
            const nn::capsrv::AlbumFileId& fileId,
            int depth
            ) NN_NOEXCEPT;

        static int GetSubDirectoryDepth() NN_NOEXCEPT;

        // @brief ファイルパスを取得します。
        static std::string GetFilePath(const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;

        // @brief 指定したパスのファイルを読み込みます。
        // @details
        //   失敗した場合 ABORT します。
        static std::vector<uint8_t> LoadFile(const char* path) NN_NOEXCEPT;

        // @brief 指定したパスにファイルを書き出します。
        // @details
        //   失敗した場合 ABORT します。
        static void SaveFile(const std::vector<uint8_t>& data, const char* path) NN_NOEXCEPT;

        // @brief 指定したパスに内容不定のファイルを作成します。
        // @details
        //   失敗した場合 ABORT します。
        static void CreateFile(int64_t size, const char* path) NN_NOEXCEPT;

        // @brief 指定したディレクトリを作成します。
        static void CreateDirectories(const char* path) NN_NOEXCEPT;

        // @brief 指定したパスの親ディレクトリを作成します。
        static void CreateParentDirectories(const char* path) NN_NOEXCEPT;

    };

}}
