﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nnt/nntest.h>

namespace nnt { namespace bluetooth { namespace connect {
    /**
     * @brief           テスト全体を末期化します
     *
     * @details         テスト終了時に 1 度だけ呼んでください
     */
    void Finalize();

    /**
     * @brief           各テストの開始処理を行います
     *
     * @details         各テストの開始時に呼んでください。
     *                  以下の処理を行います。
     *                  - BLE 接続の切断
     *                  - BLE 接続イベントをハンドリングするスレッドの開始
     *
     * @param[in]       pConnectionEvent            BLE 接続イベント発生時にシグナルされるイベントオブジェクトへのポインタ
     *
     * @pre
     *                  - pConnectionEvent != nullpter ならば、pConnectionEvent は初期化済み
     */
    void SetUp(nn::os::EventType* pConnectionEvent = nullptr);

    /**
     * @brief           各テストの終了処理を行います
     *
     * @details         各テストの終了時に呼んでください。
     *                  以下の処理を行います。
     *                  - BLE 接続の切断
     *                  - BLE 接続イベントをハンドリングするスレッドの停止
     */
    void TearDown();
}}};    // namespace nnt::bluetooth::connect

