﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testBcat_Common.h"

bool TestDirectoryName(const char* name) NN_NOEXCEPT
{
    nn::bcat::DirectoryName dirName = {};
    std::strncpy(dirName.value, name, sizeof (dirName.value));

    return dirName.IsValid();
}

bool TestFileName(const char* name) NN_NOEXCEPT
{
    nn::bcat::FileName fileName = {};
    std::strncpy(fileName.value, name, sizeof (fileName.value));

    return fileName.IsValid();
}

TEST(Types, DirectoryName)
{
    EXPECT_TRUE(TestDirectoryName("a"));
    EXPECT_TRUE(TestDirectoryName("_"));
    EXPECT_TRUE(TestDirectoryName("-"));
    EXPECT_TRUE(TestDirectoryName("a_"));
    EXPECT_TRUE(TestDirectoryName("a_b-"));
    EXPECT_TRUE(TestDirectoryName("1234567890123456789012345678901"));
    EXPECT_TRUE(TestDirectoryName("_______________________________"));
    EXPECT_TRUE(TestDirectoryName("-------------------------------"));

    EXPECT_FALSE(TestDirectoryName("."));
    EXPECT_FALSE(TestDirectoryName(".."));
    EXPECT_FALSE(TestDirectoryName("!"));
    EXPECT_FALSE(TestDirectoryName("#"));
    EXPECT_FALSE(TestDirectoryName("+"));
    EXPECT_FALSE(TestDirectoryName("/"));
    EXPECT_FALSE(TestDirectoryName("12345678901234567890123456789012"));
    EXPECT_FALSE(TestDirectoryName("________________________________"));
    EXPECT_FALSE(TestDirectoryName("--------------------------------"));
}

TEST(Types, FileName)
{
    EXPECT_TRUE(TestFileName("a"));
    EXPECT_TRUE(TestFileName("_"));
    EXPECT_TRUE(TestFileName("a_"));
    EXPECT_TRUE(TestFileName("a.b"));
    EXPECT_TRUE(TestFileName("a._"));
    EXPECT_TRUE(TestFileName(".a"));
    EXPECT_TRUE(TestFileName("._"));
    EXPECT_TRUE(TestFileName("1234567890123456789012345678901"));
    EXPECT_TRUE(TestFileName("_______________________________"));
    EXPECT_TRUE(TestFileName("a.............................b"));

    EXPECT_FALSE(TestFileName("."));
    EXPECT_FALSE(TestFileName(".."));
    EXPECT_FALSE(TestFileName("a."));
    EXPECT_FALSE(TestFileName("a.."));
    EXPECT_FALSE(TestFileName("!"));
    EXPECT_FALSE(TestFileName("#"));
    EXPECT_FALSE(TestFileName("+"));
    EXPECT_FALSE(TestFileName("/"));
    EXPECT_FALSE(TestFileName("12345678901234567890123456789012"));
    EXPECT_FALSE(TestFileName("________________________________"));
    EXPECT_FALSE(TestFileName("a..............................b"));
}
