﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/ae.h>

#include "../Common/applet_Common.h"
#include "../Common/applet_Configs.h"

void WaitInterval() NN_NOEXCEPT
{
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(200));
}

extern "C" void nnMain()
{
    nn::ae::InitializeAsSystemApplication();

    nn::os::SystemEventType event;
    nn::ae::InitializeNotificationMessageEvent(&event);

    auto aruid = nn::applet::GetAppletResourceUserId();
    NN_LOG("STARTER: ARUID = 0x%016llx\n", aruid.lower);
    NN_ABORT_UNLESS(aruid.lower != 0);

    CheckAndProcessMessage("STARTER", &event, nn::ae::Message_ChangeIntoForeground);

    NN_LOG("STARTER: Push message to SA (emulate: jump top 'set')\n");
    {
        char buffer[256];
        FillMemory(buffer, sizeof(buffer), '1');
        nn::applet::StorageHandle storageHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(CreateStorage(&storageHandle, sizeof(buffer)));
        NN_ABORT_UNLESS_RESULT_SUCCESS(WriteToStorage(storageHandle, 0, buffer, sizeof(buffer)));
        PushToSystemGeneralChannel(storageHandle);
    }

    CheckAndProcessMessage("STARTER", &event, nn::ae::Message_ChangeIntoBackground);

    CheckAndProcessMessage("STARTER", &event, nn::ae::Message_ChangeIntoForeground);

    NN_LOG("STARTER: Push home button (short): expected ignored\n");
    nn::ae::NotifyShortPressingHomeButtonForDebug();

    WaitInterval();

    NN_LOG("STARTER: Push message to SA (emulate: notify finished)\n");
    {
        char buffer[256];
        FillMemory(buffer, sizeof(buffer), '2');
        nn::applet::StorageHandle storageHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(CreateStorage(&storageHandle, sizeof(buffer)));
        NN_ABORT_UNLESS_RESULT_SUCCESS(WriteToStorage(storageHandle, 0, buffer, sizeof(buffer)));
        PushToSystemGeneralChannel(storageHandle);
    }

    NN_LOG("STARTER: Push home button (short)\n");
    nn::ae::NotifyShortPressingHomeButtonForDebug();

    for (;;)
    {
        WaitInterval();
    }
}
