﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nnt/gtest/gtest.h>
#include <nnd/bh1730fvc/bh1730fvc.h>

#include "testBh1730_Common.h"

namespace nnt { namespace bh1730fvc {

namespace {

const nnd::bh1730fvc::Gain gainTable[] =
{
        nnd::bh1730fvc::Gain::X1,
        nnd::bh1730fvc::Gain::X2,
        nnd::bh1730fvc::Gain::X64,
        nnd::bh1730fvc::Gain::X128,
};

const int       IntegralCycleMin    = 1;   // 最小値
const int       IntegralCycleMax    = 255;   // 最大値
}

// IntegralCycle
TEST(SetIntegralCycleTest, Settings)
{
    using namespace nnd::bh1730fvc;

    Initialize();

    ::nn::Result result;

    // 成功
    for (auto cycle = IntegralCycleMin; cycle < IntegralCycleMax; cycle++)
    {
        int tmp = cycle;
        result = SetIntegralCycle(tmp);
        EXPECT_TRUE(result.IsSuccess());
        result = GetIntegralCycle(&tmp);
//        NN_LOG("Set = %3d, Get = %3d\n",cycle, tmp);
        EXPECT_TRUE(result.IsSuccess());
        EXPECT_EQ(cycle, tmp);
    }

    // 失敗：最小値以下の範囲外
    for (auto cycle = IntegralCycleMin - 1; IntegralCycleMin - 10 < cycle; cycle--)
    {
        EXPECT_DEATH_IF_SUPPORTED(SetIntegralCycle(cycle), "");
    }

    // 失敗：最大値以上の範囲外
    for (auto cycle = IntegralCycleMax + 1; cycle < IntegralCycleMin + 10; cycle++)
    {
        EXPECT_DEATH_IF_SUPPORTED(SetIntegralCycle(cycle), "");
    }

    Finalize();
}

// SetGain
TEST(SetGainTest, Settings)
{
    using namespace nnd::bh1730fvc;

    Initialize();

    ::nn::Result result;

    for (auto gain : gainTable)
    {
        Gain tmp = gain;
        result = SetGain(tmp);
        EXPECT_TRUE(result.IsSuccess());
        result = GetGain(&tmp);
        EXPECT_TRUE(result.IsSuccess());
        EXPECT_EQ(gain, tmp);
    }

    Finalize();
}

}}
