﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>

#include <nnd/bh1730fvc/bh1730fvc.h>

extern "C" void nnMain()
{
    using namespace nnd::bh1730fvc;

    const int MeasurementLoop = 50;

    // 初期状態では結果が得られるまでに 104.6ms を必要とする
    // (計測積分時間 102.6ms + 内部処理 2ms)
    const int WaitMilliSec = 110;

    NN_LOG("/// BH1730FVC Read Lux ///\n");

    NN_LOG("Initialize()\n");
    Initialize();

    MeasurementMode mode;
    NN_LOG("GetMeasurementMode()\n");
    GetMeasurementMode(&mode);
    NN_LOG("mode: %d\n", mode);

    NN_LOG("SetMeasurementMode(MeasurementMode::Continuous)\n");
    SetMeasurementMode(MeasurementMode::Continuous);
    NN_LOG("GetMeasurementMode()\n");
    GetMeasurementMode(&mode);
    NN_LOG("mode: %d\n", mode);

    // 最初の計測が完了するまで待つ
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(WaitMilliSec));

    MeasurementValue val;
    for (int i = 0; i < MeasurementLoop; i++)
    {
        GetMeasurementValue(&val);
        NN_LOG("Lux: %12.6f, (Visible=%4x, Infrared= %4x)\n", val.lux, val.visible, val.infrared);

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(WaitMilliSec));
    }

    NN_LOG("Finalize()\n");
    Finalize();
}
