﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/album/album_SaveScreenshot.h>
#include <nn/album/album_SaveAndShareScreenshot.h>
#include <nn/album/album_ScreenshotApi.private.h>
#include <nn/album/album_AlbumFileEntry.private.h>
#include <nn/album/album_ExtraMediaFileAccess.private.h>

#include <vector>
#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include <nnt.h>

#define NNT_ALBUM_CALL_API(expr)    \
    do{                             \
        auto result = expr;         \
        NN_LOG("API: " #expr "\n"); \
        NN_LOG("  -> %d-%d\n", result.GetModule(), result.GetDescription());    \
    }while(NN_STATIC_CONDITION(false))

// 一通り呼び出してビルドが通ることを確かめる
TEST(ScreenshotApi, BuildCheck)
{
    auto imageSize = nn::album::ImageSize_1280x720;
    int width = nn::album::GetImageWidth(imageSize);
    int height = nn::album::GetImageHeight(imageSize);

    auto reportOption = nn::album::AlbumReportOption_ReportAlways;

    std::vector<uint8_t> storage;
    storage.resize(4 * width * height, 0xFF);
    void* data = storage.data();
    size_t dataSize = storage.size();

    auto orientation = nn::album::ImageOrientation_None;
    auto uid = nn::account::InvalidUid;
    const char* msg = "#ThisIsWhite";

    nn::album::ShareId outShareId;

    nn::album::Initialize();
    NN_UTIL_SCOPE_EXIT{ nn::album::Finalize(); };

    // SaveScreenshot 類
    NNT_ALBUM_CALL_API(nn::album::SaveScreenshot(data, dataSize, imageSize, reportOption));
    NNT_ALBUM_CALL_API(nn::album::SaveScreenshot(data, dataSize, imageSize, orientation, reportOption));

    // SaveAndShareScreenshot 類
    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(data, dataSize, imageSize, reportOption, uid));
    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(data, dataSize, imageSize, orientation, reportOption, uid));

    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(&outShareId, data, dataSize, imageSize, reportOption, uid));
    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(&outShareId, data, dataSize, imageSize, orientation, reportOption, uid));

    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(data, dataSize, imageSize, reportOption, uid, msg));
    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(data, dataSize, imageSize, orientation, reportOption, uid, msg));
    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(&outShareId, data, dataSize, imageSize, reportOption, uid, msg));
    NNT_ALBUM_CALL_API(nn::album::SaveAndShareScreenshot(&outShareId, data, dataSize, imageSize, orientation, reportOption, uid, msg));


}

