﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "baas/account_BaasProblemDetails.h"
#include <nn/account/baas/account_ResultForBaas.h>

#include <nn/account/json/account_RapidJsonApi.h>
#include <nn/account/json/account_RapidJsonStream.h>
#include "detail/account_UuidUtil.h"

#include "testAccount_Mounter.h"
#include "testAccount_Util.h"
#include "testAccount_JsonPrintAdaptor.h"
#include "testAccount_RapidJsonInputStream.h"

#include <nnt/nntest.h>

#include <nn/nn_Log.h>

namespace a = nn::account;
namespace t = nnt::account;

#define NNT_ACCOUNT_ENABLE_BAAS_PROBLEM_DETAIL

namespace
{
struct Error
{
    int32_t httpCode;
    const char* json;
};
} // ~namespace <anonymous>

#if defined(NNT_ACCOUNT_ENABLE_BAAS_PROBLEM_DETAIL)

namespace problemDetails
{

class BaasErrorAdaptor
    : public a::baas::BaasCommonAdaptor<4, 16>
{
public:
    virtual nn::Result AdaptImpl() NN_NOEXCEPT NN_OVERRIDE
    {
        NN_RESULT_SUCCESS;
    }
    virtual bool UpdateImpl(const JsonPathType&, int64_t) NN_NOEXCEPT NN_OVERRIDE
    {
        return false;
    }
    virtual bool UpdateImpl(const JsonPathType&, const char*, int) NN_NOEXCEPT NN_OVERRIDE
    {
        return false;
    }
};

const Error Inputs[] = {
    {400, "{\"status\":400,\"instance\":\"https://baas.nintendo.com/1.0.0/application/token\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_params\",\"title\":\"Invalid Params\",\"detail\":\"invalid params\",\"errorCode\":\"invalid_params\"}"},
    {400, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users\",\"errorCode\":\"invalid_request\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_request\",\"title\":\"Authorizationheadervalueisinvalid\",\"status\":400,\"detail\":\"Authschemeorauthparamsisinvalid\"}"},
    {400, "{\"detail\":\"Invalid device account\",\"instance\":\"https://baas.nintendo.com/1.0.0/login\",\"status\":400,\"title\":\"InvalidDeviceAccount\",\"errorCode\":\"invalid_device_account\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_device_account\"}"},
    {400, "{\"detail\":\"error_internal_model_jwt_ndas_invalid_app_authn_tokeninvalidNDASappauthenticationtoken:nomatchingkeyforusage:,kid:01827a56-40d1-4797-b6b7-7067bafdbb0dlib/Yasaka/Model/JWT/NDASAppAuthNToken.pmline70\",\"title\":\"InvalidNDASAppAuthNToken\",\"status\":400,\"errorCode\":\"invalid_ndas_app_authn_token\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_ndas_app_authn_token\",\"instance\":\"https://baas.nintendo.com/1.0.0/login\"}"},
    {400, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"status\":400,\"title\":\"InvalidIdP\",\"errorCode\":\"invalid_idp\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_idp\",\"detail\":\"Invalid IdP\"}"},
    {400, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"status\":400,\"title\":\"InvalidIdPAccount\",\"errorCode\":\"invalid_idp_account\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_idp_account\",\"detail\":\"Invalid IdP account\"}"},
    {400, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"status\":400,\"title\":\"LinkedUserNotFound\",\"errorCode\":\"linked_user_not_found\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/linked_user_not_found\",\"detail\":\"Linked user not found\"}"},
    {400, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"status\":400,\"title\":\"FriendCodeFormat\",\"errorCode\":\"invalid_friend_code_format\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_friend_code_format\",\"detail\":\"Invaid friend code format\"}"},
    {400, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"status\":400,\"title\":\"LinkNotExist\",\"errorCode\":\"user_link_not_exist\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/user_link_not_exist\",\"detail\":\"User link not exist\"}"},
    {400, "{\"title\":\"InvalidRawContent\",\"instance\":\"https://baas.nintendo.com/1.0.0/image_upload\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/400/invalid_raw_content\",\"errorCode\":\"invalid_raw_content\",\"detail\":\"invalidrawcontent\",\"status\":400}"},
    {400, "{\"status\":400}"},
    {400, "{\"errorCode\":\"invalid_params\"}"},
    {400, "{}"},

    {401, "{\"instance\":\"https://baas.nintendo.com/1.0.0/users\",\"status\":401,\"title\":\"Tokenisinvalid\",\"errorCode\":\"invalid_token\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/401/invalid_token\",\"detail\":\"Theaccesstokenwasinvalid\"}"},
    {403, "{\"detail\":\"Theaccesstokendoesnothavesufficientscope\",\"title\":\"Tokenisinsufficient\",\"status\":403,\"errorCode\":\"insufficient_scope\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/insufficient_scope\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\"}"},
    {403, "{\"detail\":\"Forbidden\",\"title\":\"Forbidden\",\"status\":403,\"errorCode\":\"forbidden\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/forbidden\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\"}"},
    {403, "{\"detail\":\"UnavailableDeviceAccount\",\"title\":\"UnavailableDeviceAccount\",\"status\":403,\"errorCode\":\"unavailable_device_account\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/unavailable_device_account\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\"}"},
    {403, "{\"errorCode\":\"membership_required\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/membership_required\",\"detail\":\"MembershipRequired\",\"title\":\"MembershipRequired\",\"status\":403,\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\"}"},
    {404, "{\"detail\":\"Resourceisnotfound\",\"title\":\"ResourceIsNotFound\",\"status\":404,\"errorCode\":\"resource_is_not_found\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/resource_is_not_found\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\"}"},
    {405, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/405/method_not_allowed\",\"errorCode\":\"method_not_allowed\",\"status\":405,\"title\":\"MethodNotAllowed\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Methodnotallowed\"}"},
    {406, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/406/not_acceptable_language\",\"errorCode\":\"not_acceptable_language\",\"status\":406,\"title\":\"NotAcceptableLanguage\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Notacceptablelanguage\"}"},
    {409, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/409/resource_already_exists\",\"errorCode\":\"resource_already_exists\",\"status\":409,\"title\":\"ResourceAlreadyExists\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Resourcealreadyexists\"}"},
    {409, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/409/user_link_already_exists\",\"errorCode\":\"user_link_already_exists\",\"status\":409,\"title\":\"UserLinkAlreadyExists\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Userlinkalreadyexists\"}"},
    {412, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/412/precondition_failed\",\"errorCode\":\"precondition_failed\",\"status\":412,\"title\":\"PreconditionFailed\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Preconditionfailed\"}"},
    {422, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/422/friend_code_unregenerable_state\",\"errorCode\":\"friend_code_unregenerable_state\",\"status\":422,\"title\":\"FriendCodeUnregenerableState\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Friendcodeunregenerablestate\"}"},
    {403, "{\"detail\":\"Banned user\",\"title\":\"BannedUser\",\"status\":403,\"errorCode\":\"banned_user\",\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/banned_user\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\"}"},
    {403, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/403/banned_user_by_application\",\"errorCode\":\"banned_user_by_application\",\"status\":403,\"title\":\"BannedUserByApplication\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"BannedUserByApplication\"}"},
    {404, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/404/deleted_user\",\"errorCode\":\"deleted_user\",\"status\":404,\"title\":\"DeletedUser\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"DeletedUser\"}"},
    {422, "{\"status\":422}"},
    {422, "{\"errorCode\":\"friend_code_unregenerable_state\"}"},
    {401, "{}"},

    {500, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/500/internal_server_error\",\"errorCode\":\"internal_server_error\",\"status\":500,\"title\":\"InternalServerError\",\"instance\":\"https://baas.nintendo.com/1.0.0/users/...\",\"detail\":\"Internalservererror\"}"},
    {502, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/502/could_not_confirm_membership\",\"errorCode\":\"could_not_confirm_membership\",\"status\":502,\"title\":\"Could Not Confirm Membership\",\"instance\":\"about:blank\",\"detail\":\"Counld not confirm membership\"}"},
    {503, "{\"type\":\"https://baas.nintendo.com/errors/1.0.0/503/under_maintenance\",\"errorCode\":\"under_maintenance\",\"status\":503,\"title\":\"Under Maintenance\",\"instance\":\"about:blank\",\"detail\":\"Service is under maintenance\"}"},
    {504, "{\"status\":504}"},
    {504, "{\"errorCode\":\"gateway_timeout\"}"},
    {500, "{}"},

    {300, "{}"},
};
const nn::Result Expects[] = {
    nn::account::baas::ResultBaasStatus400InvalidParams(),
    nn::account::baas::ResultBaasStatus400InvalidRequest(),
    nn::account::baas::ResultBaasStatus400InvalidDeviceAccount(),
    nn::account::baas::ResultBaasStatus400InvalidNdasAppAuthnToken(),
    nn::account::baas::ResultBaasStatus400InvalidIdp(),
    nn::account::baas::ResultBaasStatus400InvalidIdpAccount(),
    nn::account::baas::ResultBaasStatus400LinkedUserNotFound(),
    nn::account::baas::ResultBaasStatus400InvalidFriendCodeFormat(),
    nn::account::baas::ResultBaasStatus400UserLinkNotExist(),
    nn::account::baas::ResultBaasStatus400InvalidRawContent(),
    nn::account::http::ResultHttpStatus400BadRequest(),
    nn::account::http::ResultHttpStatus400BadRequest(),
    nn::account::http::ResultHttpStatus400BadRequest(),

    nn::account::baas::ResultBaasStatus401InvalidToken(),
    nn::account::baas::ResultBaasStatus403InsufficientScope(),
    nn::account::baas::ResultBaasStatus403Forbidden(),
    nn::account::baas::ResultBaasStatus403UnavailableDeviceAccount(),
    nn::account::baas::ResultBaasStatus403MembershipRequired(),
    nn::account::baas::ResultBaasStatus404ResourceIsNotFound(),
    nn::account::baas::ResultBaasStatus405MethodNotAllowed(),
    nn::account::baas::ResultBaasStatus406NotAcceptableLanguage(),
    nn::account::baas::ResultBaasStatus409ResourceAlreadyExists(),
    nn::account::baas::ResultBaasStatus409UserLinkAlreadyExists(),
    nn::account::baas::ResultBaasStatus412PreconditionFailed(),
    nn::account::baas::ResultBaasStatus422FriendCodeUnregenerableState(),
    nn::account::baas::ResultBaasStatus403BannedUser(),
    nn::account::baas::ResultBaasStatus403BannedUserByApplication(),
    nn::account::baas::ResultBaasStatus404DeletedUser(),
    nn::account::http::ResultHttpStatus4xx(),
    nn::account::http::ResultHttpStatus4xx(),
    nn::account::http::ResultHttpStatus401Unauthorized(),

    nn::account::baas::ResultBaasStatus500InternalServerError(),
    nn::account::baas::ResultBaasStatus502CouldNotConfirmMembership(),
    nn::account::baas::ResultBaasStatus503UnderMaintenance(),
    nn::account::http::ResultHttpStatus504GatewayTimeout(),
    nn::account::http::ResultHttpStatus504GatewayTimeout(),
    nn::account::http::ResultHttpStatus500InternalServerError(),

    nn::account::http::ResultHttpUnsupportedStatusCode(),
};

void RunTest(nn::Result expectation, const Error& e) NN_NOEXCEPT
{
    t::MemoryInputStreamForRapidJson stream;
    stream.Set(e.json, strlen(e.json));

    BaasErrorAdaptor adaptor;
    NNT_ACCOUNT_ASSERT_RESULT_SUCCESS(nn::account::json::ImportJsonByRapidJson(adaptor, stream));
    ASSERT_EQ(expectation.GetInnerValueForDebug(), adaptor.Adapt(e.httpCode).GetInnerValueForDebug());
}

} // ~namespace problemDetails

TEST(AccountAdaptor, BaasProblemDetail)
{
    for (auto i = 0; i < sizeof(problemDetails::Inputs) / sizeof(problemDetails::Inputs[0]); ++ i)
    {
        problemDetails::RunTest(
            problemDetails::Expects[i],
            problemDetails::Inputs[i]);
    }
}

#endif // NNT_ACCOUNT_ENABLE_BAAS_PROBLEM_DETAIL
