﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_FileSystem.h>

#include <nn/nn_Result.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/os/os_SdkMutex.h>

namespace nnt { namespace account {

class RamFs
    : public nn::account::detail::AbstractFileSystem
{
private:
    static nn::os::SdkRecursiveMutex s_WriterLock;
    static nn::os::SdkMutex s_TableLock;

    static nn::Result DeleteDirectoryImpl(const char* path) NN_NOEXCEPT;

public:
    static nn::Result MountHost(const char* volumeName, const char* hostLocation) NN_NOEXCEPT;
    static nn::Result MountSave(const char* volumeName, nn::fs::SystemSaveDataId saveDataId, int64_t dataSize, int64_t journalSize, uint32_t flags) NN_NOEXCEPT;
    static nn::Result Unmount(const char* volumeName) NN_NOEXCEPT;
    static nn::Result Commit(const char* volumeName) NN_NOEXCEPT;

    static nn::Result Setup(const char* rootPath) NN_NOEXCEPT;
    static void ClearProfile(const char* rootPath) NN_NOEXCEPT;
    static void ClearCache(const char* rootPath) NN_NOEXCEPT;
    static void Clear(const char* rootPath) NN_NOEXCEPT;

    static nn::account::detail::FsLockGuard AcquireWriterLock() NN_NOEXCEPT;

    // 独自
    static size_t GetEntryCountOn(const char* path) NN_NOEXCEPT;

public:
    // ファイルの操作
    virtual nn::Result Create(const char* path, size_t sizeToReserve) const NN_NOEXCEPT;
    virtual nn::Result Delete(const char* path) const NN_NOEXCEPT;
    virtual nn::Result Write(const char* path, const void* buffer, size_t bufferSize) const NN_NOEXCEPT;
    virtual nn::Result Append(const char* path, size_t offset, const void* buffer, size_t bufferSize) const NN_NOEXCEPT;
    virtual nn::Result GetSize(size_t* pOutSize, const char* path) const NN_NOEXCEPT;
    virtual nn::Result SetSize(const char* path, size_t size) const NN_NOEXCEPT;
    virtual nn::Result Read(size_t* pOutActualSize, void* buffer, size_t bufferSize, const char* path, size_t offsetconst ) const NN_NOEXCEPT;
    virtual nn::Result Read(size_t* pOutActualSize, void* buffer, size_t bufferSize, const char* path) const NN_NOEXCEPT;
    virtual nn::Result Move(const char* to, const char* from) const NN_NOEXCEPT;
    virtual nn::Result Copy(const char* to, const char* from, void* buffer, size_t bufferSize) const NN_NOEXCEPT;
};

}}
