﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Host.h>
#include <nn/fs/fs_Result.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_UuidApi.h>
#include <nn/util/util_ScopeExit.h>

namespace nnt { namespace account {

const char* CreateTestDirectory(char* pathBuffer, size_t pathBufferSize) NN_NOEXCEPT
{
    nn::fs::MountHostRoot();

    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::UnmountHostRoot();
    };

    static const char HostLocationBase[] = "C:\\Windows\\Temp\\nntAccount_%s";
    for (int i = 0; i < 100; i++)
    {
        char str[64];
        nn::util::SNPrintf(pathBuffer, pathBufferSize, HostLocationBase, nn::util::GenerateUuid().ToString(str, sizeof(str)));
        auto r = nn::fs::CreateDirectory(pathBuffer);
        if (r.IsSuccess())
        {
            return pathBuffer;
        }
        NN_ABORT_UNLESS(nn::fs::ResultPathAlreadyExists::Includes(r));
    }
    return nullptr;
}

}} // ~namespace nnt::account
