﻿# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals
from HACDllDriver import factory, Button, CaptureMode

import os
import sys
import time

os.chdir( os.path.dirname(os.path.abspath(__file__)))

"""
(本体機能) HOMEメニュー上で簡単な操作を行うサンプルです。
TargetManager にて対象開発機へ接続した状態で、InputDirector を起動してから実行する必要があります。
HOMEメニューから、本体設定を開き Mii の編集、アルバム画面操作などの処理を示したサンプルです。
"""

def touch_by_target_image(driver, image_path, ms_after = 1000):
    target_image    = driver.screen.load_image( image_path )
    result    = driver.screen.detect_object( target_image )
    driver.screen.release_image( target_image )
    if result is not None:
        x = result[0]
        y = result[1]
        driver.screen.touch( 0, x + 10, y + 10, ms_after = ms_after )
        return True
    else:
        print("Target image was not found")
        return False

if __name__ == "__main__":
    # sys.argv[1] = 対象のシリアルナンバー
    serial_number = None
    if len(sys.argv) != 1:
        serial_number = sys.argv[1]

    with factory(serial_number, is_preview=True, capture_device_id=None, capture_mode=CaptureMode.CaptureMode_720p) as __driver:
        __driver.controllers.close_all()

        __play_controller_id = __driver.controllers.add()
        __driver.controllers[__play_controller_id].set_neutral()

        # HOME 画面へ戻る
        __driver.controllers[__play_controller_id].push(Button.HOME, ms_after = 500)

        # 画像を保存
        if not os.path.exists("SaveImage"):
            os.mkdir("SaveImage")
        imagehandle = __driver.screen.get_image()
        if not __driver.screen.save_image( "SaveImage/01.png", imagehandle ):
            print("save_image failed")
        __driver.screen.release_image(imagehandle)

        # 画面遷移( Home -> Setting )
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.RIGHT,   ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.RIGHT,   ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.RIGHT,   ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.RIGHT,   ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.A,       ms_after = 1000)

        # 画面遷移確認
        config_screen_image = __driver.screen.load_image( "TemplateImage/Config_Screen_Banner.png" )
        result = __driver.screen.wait_detect_object( config_screen_image, 10000)
        __driver.screen.release_image( config_screen_image )
        if result is None:
            print("Failed to move settings scene")
            sys.exit(-1)

        # 設定画面操作(Mii を選択）
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)
        __driver.controllers[__play_controller_id].push(Button.DOWN,    ms_after = 300)

        # タッチで遷移 ( Setting -> MiiEditor )
        if not touch_by_target_image(__driver, "TemplateImage/MiiEditor/Create_Or_Edit_Mii.png", ms_after = 5000):
            sys.exit(-1)
        if not touch_by_target_image(__driver, "TemplateImage/MiiEditor/Make_New.png"):
            sys.exit(-1)

        __driver.controllers[__play_controller_id].push(Button.A,   ms_after = 1000)

        # 画面遷移確認
        complete_button_image = __driver.screen.load_image( "TemplateImage/MiiEditor/Complete_Button.png" )
        result = __driver.screen.wait_detect_object( complete_button_image, 10000)
        __driver.screen.release_image( complete_button_image )
        if result is None:
            print("Failed to move MiiEditor scene")
            sys.exit(-1)

        # 画面をキャプチャ
        __driver.controllers[__play_controller_id].push(Button.CAPTURE,   ms_after = 1000)

        # フリック操作
        for i in range(5):
            __driver.screen.flick( 0, 1100, 350, angle_deg = 180, ms_duration = 500, ms_after = 1000 )

        # 画面遷移( MiiEditor -> Home -> Album )
        __driver.controllers[__play_controller_id].push(Button.B,   ms_after = 1000)
        __driver.controllers[__play_controller_id].push(Button.HOME,   ms_after = 3000)

        if not touch_by_target_image(__driver, "TemplateImage/Home/Album_Icon.png", ms_after = 3000):
            sys.exit(-1)
        __driver.controllers[__play_controller_id].push(Button.A,   ms_after = 5000)

        # 画像を拡大・縮小(ピンチ操作)
        __driver.controllers[__play_controller_id].push(Button.A,   ms_after = 1000)
        for i in range(3):
            __driver.screen.pinch([0, 1, 2], 640, 360, 200, ms_after = 1000)
            __driver.screen.pinch([0, 1, 2, 3], 640, 360, -200, start_radius=300, ms_after = 1000)
        __driver.controllers[__play_controller_id].push(Button.B,   ms_after = 3000)

        # 画像を削除
        __driver.controllers[__play_controller_id].push(Button.X,   ms_after = 1000)
        __driver.controllers[__play_controller_id].push(Button.A,   ms_after = 1000)
        if not touch_by_target_image(__driver, "TemplateImage/Album/Delete_Button.png", ms_after = 3000):
            sys.exit(-1)
        __driver.controllers[__play_controller_id].push(Button.A,   ms_after = 3000)

        # 画面遷移( Setting -> Home )
        __driver.controllers[__play_controller_id].push(Button.B,   ms_after = 1000)
        __driver.controllers[__play_controller_id].push(Button.HOME,   ms_after = 1000)
        __driver.controllers[__play_controller_id].set_neutral()
