﻿# coding: utf-8
from System.IO import *
from System.Text import *
from System.Globalization import *

def Filter(target):
	# モデルが参照しているテクスチャリストの作成
	if target.Extension == ".fmdb" or target.Extension == ".fmda":
		tex_folder = Path.Combine(Path.GetDirectoryName(target.FullPath), "textures")
		target.Result = []
		for tex_name in target.Document.SelectNodes(
			"/nw4f_3dif/model/material_array/material/sampler_array/sampler/@tex_name"):
			target.Result.append(Path.Combine(tex_folder, tex_name.Value + ".ftxb"))

	# テクスチャパターンアニメが参照しているテクスチャリストの作成
	elif target.Extension == ".ftpb" or target.Extension == ".ftpa":
		tex_folder = Path.Combine(Path.GetDirectoryName(target.FullPath), ScriptArgument)
		target.Result = []
		for tex_name in target.Document.SelectNodes(
			"/nw4f_3dif/tex_pattern_anim/tex_pattern_array/tex_pattern/@tex_name"):
			target.Result.append(Path.Combine(tex_folder, tex_name.Value + ".ftxb"))

def PostFilter(targets):
	# テクスチャのリストアップ
	texture_paths = {}
	for target in targets:
		if target.Extension == ".ftxb" or target.Extension == ".ftxa":
			texture_path = target.FullPath
			texture_paths[texture_path.GetHashCode()] = texture_path

	# .ftxb、.ftxa 混在を識別するために、使用済みテクスチャをまとめる
	used_textures = {}
	for target in targets:
		if target.Result != None:
			for used_texture in target.Result:
				hash = used_texture.GetHashCode()
				if not hash in used_textures:
					used_textures[hash] = used_texture
					print(used_texture)

	# テクスチャリストから使用済みテクスチャを削除
	for used_texture_path in used_textures.values():
		hash = used_texture_path.GetHashCode()
		if hash in texture_paths:
			del texture_paths[hash]
			continue

		# .ftxb が見つからなかった場合のみ、.ftxa を参照する
		used_texture_path = Path.ChangeExtension(used_texture_path, ".ftxa")
		hash = used_texture_path.GetHashCode()
		if hash in texture_paths:
			del texture_paths[hash]

	# 未使用テクスチャリストの出力
	result = ("\"FullPath\"\r\n")
	for texture_path in texture_paths.values():
		result += "\"" + texture_path + "\"\r\n"

	# 文字化けを防ぐためにエンコーディングを指定する
	encoding = Encoding.GetEncoding(CultureInfo.CurrentCulture.TextInfo.ANSICodePage)
	File.WriteAllText("UnusedTexture.csv", result, encoding)
