﻿# coding: utf-8
from System.IO import *
from System.Text import Encoding

FileFilters = (
	("create", "user"),
	("create", "host"),
	("create", "tool_name"),
#	("create", "tool_version"),
	("create", "src_path"),
	("modify", "user"),
	("modify", "host"),
	("modify", "tool_name"),
#	("modify", "tool_version")
	)

ModelFilters = (
#	("model_info", "dcc_preset"),
	("material", "name"),
#	("sampler", "name"),
#	("sampler", "hint"),
	("sampler", "tex_name"),
	("shader_assign", "shader_archive"),
	("shader_assign", "shading_model"),
	("render_info", "name"),
	("shader_option", "id"),
	("sampler_assign", "id"),
	("sampler_assign", "sampler_name"),
	("shader_param", "id"),
	("shader_param", "original_hint"),
	("attrib_assign", "id"),
	("attrib_assign", "attrib_name"),
	("bone", "name"),
	("bone", "parent_name"),
	("vtx_attrib", "name"),
#	("vtx_attrib", "hint"),
	("shape", "name"),
	("shape_info", "mat_name"),
	("shape_info", "bone_name"),
#	("shape_info", "original_shape_hash"),
	("shape_info", "delete_near_vertex_mode"),
	("shape_info", "divide_submesh_mode"),
	("key_shape", "name"),
	("target_attrib", "attrib_name"),
	("original_material", "mat_name"),
#	("original_color", "hint"),
#	("original_texsrt", "hint")
	)

TextureFilters = (
#	("texture_info", "dcc_preset"),
#	("texture_info", "hint"),
	("original_image", "original_path")
	)

SkeletalAnimFilters = (
#	("skeletal_anim_info", "dcc_preset"),
	("bone_anim", "bone_name"),
	("bone_anim", "parent_name")
	)

ShaderParamAnimFilters = (
#	("shader_param_anim_info", "dcc_preset"),
	("shader_param_mat_anim", "mat_name"),
	("param_anim", "id"),
	("param_anim", "original_hint"),
	("original_material_anim", "mat_name"),
#	("original_color_anim", "hint"),
#	("original_texsrt_anim", "hint")
	)

TexPatternAnimFilters = (
#	("tex_pattern_anim_info", "dcc_preset"),
	("tex_pattern", "tex_name"),
	("tex_pattern_mat_anim", "mat_name"),
	("pattern_anim_target", "sampler_name"),
#	("pattern_anim_target", "hint")
	)

BoneVisibilityAnimFilters = (
#	("bone_visibility_anim_info", "dcc_preset"),
	("bone_vis_bone_anim", "bone_name"),
	("bone_vis_bone_anim", "parent_name")
	)

MaterialVisibilityAnimFilters = (
#	("mat_visibility_anim_info", "dcc_preset"),
	("mat_vis_mat_anim", "mat_name")
	)

ShapeAnimFilters = (
#	("shape_anim_info", "dcc_preset"),
	("vertex_shape_anim", "shape_name"),
	("vertex_shape_anim", "base_name"),
	("shape_anim_target", "base_value")
	)

SceneAnimFilters = (
#	("scene_anim_info", "dcc_preset"),
	("camera_anim", "camera_name"),
	("light_anim", "light_name"),
	("light_anim", "type"),
	("light_anim", "dist_attn_func"),
	("light_anim", "angle_attn_func"),
	("fog_anim", "fog_name"),
	("fog_anim", "dist_attn_func")
	)

ShaderConfigFilters = (
	("include_path", "path"),
	("force_include_file", "path"),
	("shader", "name"),
	("vertex_shader", "path"),
	("geometry_shader", "path"),
	("fragment_shader", "path"),
	("macro", "name"),
	("macro", "value"),
	("variation", "id"),
#	("variation", "choice"),
#	("variation", "default")
	)

ShaderDefinitionFilters = (
	("shader_definition_info", "config_path"),
	("shading_model", "name"),
	("macro", "name"),
	("macro", "value"),
	("option_var", "id"),
#	("option_var", "choice"),
#	("option_var", "default"),
	("vertex_symbol", "name"),
	("geometry_symbol", "name"),
	("fragment_symbol", "name"),
	("ui_label", "value"),
	("ui_comment", "value"),
	("ui_group", "group_name"),
	("attrib_var", "id"),
#	("attrib_var", "hint"),
	("sampler_var", "id"),
#	("sampler_var", "hint"),
	("sampler_var", "alt"),
	("block_var", "id"),
	("uniform_var", "id"),
#	("uniform_var", "hint"),
	("render_info_slot", "name"),
#	("render_info_slot", "choice"),
#	("render_info_slot", "default"),
	("interleave", "id_set"),
	("group", "name"),
	("group", "condition"),
	("streamout", "varying"),
	("shader_src", "include_path"),
	("shader_src", "path")
	)

ShaderVariationFilters = (
	("shader_variation_info", "shader_archive"),
	("target_shader", "shading_model_name"),
	("option", "id"),
#	("option", "choice")
	)

def Filter(target):
	target.Result = ["", []]
	target.Result[0] = "\n" + target.FileName
	ExtractName(target, FileFilters)
	if target.Extension == ".fmdb" or target.Extension == ".fmda":
		ExtractName(target, ModelFilters)
	elif target.Extension == ".ftxb" or target.Extension == ".ftxa":
		ExtractName(target, TextureFilters)
	elif target.Extension == ".fskb" or target.Extension == ".fska":
		ExtractName(target, SkeletalAnimFilters)
	elif target.Extension == ".fspb" or target.Extension == ".fspa" or target.Extension == ".fclb" or target.Extension == ".fcla" or target.Extension == ".ftsb" or target.Extension == ".ftsa":
		ExtractName(target, ShaderParamAnimFilters)
	elif target.Extension == ".ftpb" or target.Extension == ".ftpa":
		ExtractName(target, TexPatternAnimFilters)
	elif target.Extension == ".fvbb" or target.Extension == ".fvba":
		ExtractName(target, BoneVisibilityAnimFilters)
	elif target.Extension == ".fvmb" or target.Extension == ".fvma":
		ExtractName(target, MaterialVisibilityAnimFilters)
	elif target.Extension == ".fshb" or target.Extension == ".fsha":
		ExtractName(target, ShapeAnimFilters)
	elif target.Extension == ".fsnb" or target.Extension == ".fsna":
		ExtractName(target, SceneAnimFilters)
	elif target.Extension == ".fscb" or target.Extension == ".fsca":
		ExtractName(target, ShaderConfigFilters)
	elif target.Extension == ".fsdb" or target.Extension == ".fsda":
		ExtractName(target, ShaderDefinitionFilters)
	elif target.Extension == ".fsvb" or target.Extension == ".fsva":
		ExtractName(target, ShaderVariationFilters)

def ExtractName(target, filters):
	for filter in filters:
		for elem in target.Document.SelectNodes("//" + filter[0]):
			value = elem.GetAttribute(filter[1])
			target.Result[0] += "\n," + filter[0] + "," + filter[1] + "," + value
			target.Result[1].append(value)

def PostFilter(targets):
	unique = "UniqueNames\n"
	result = "Filename,Element,Attribute,Name"
	for target in targets:
		result += target.Result[0]
		for value in target.Result[1]:
			if unique.Contains("\n" + value + "\n") == False:
				unique += value + "\n"
	File.WriteAllText(ScriptArgument, result, Encoding.UTF8)
	File.WriteAllText("Unique" + ScriptArgument, unique, Encoding.UTF8)
