﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

layout(triangles) in;
layout(triangle_strip, max_vertices=3) out;

in gl_PerVertex
{
  vec4 gl_Position;
} gl_in[];

layout(location = 0) in Inputs
{
    vec4 vColor;
    in vec4 vTexCoord[3];
}gin[3];

layout(location = 0) out vec4 vColor;
layout(location = 1) out vec4 vTexCoord[3];

layout(std140) uniform uConstantBufferForGeometryShader
{
    vec4    uRatio;
};

void main()
{
    gl_Position = gl_in[0].gl_Position;
    vColor = gin[1].vColor;
    vTexCoord[0] = gin[0].vTexCoord[0];
    EmitVertex();

    gl_Position = mix(gl_in[0].gl_Position, gl_in[1].gl_Position, uRatio.x);
    vColor = mix(gin[0].vColor, gin[1].vColor, uRatio.x);
    vTexCoord[0] = mix(gin[0].vTexCoord[0], gin[1].vTexCoord[0], uRatio.x);
    EmitVertex();

    gl_Position = mix(gl_in[0].gl_Position, gl_in[2].gl_Position, uRatio.x);
    vColor = mix(gin[0].vColor, gin[2].vColor, uRatio.x);
    vTexCoord[0] = mix(gin[0].vTexCoord[0], gin[2].vTexCoord[0], uRatio.x);
    EmitVertex();

    EndPrimitive();
}
