@echo off
rem
rem this script is called with 3 arguments:
rem the Platform (Win32 or Cafe)
rem the Configuration (NX_Debug, Debug, Release, etc.)
rem the output file name (base only, extension is added by us)
rem After these 3 come any additional arguments, such as the vertex
rem shader and fragment shader.
rem

set SdkRoot=%1
set Platform=%2
set Config=%3
set OutName=%4
shift
shift
shift
shift

rem echo Platform=%Platform%
rem echo Config=%Config%
rem goto :end

rem Test Platform for Win32, NX, or Cafe

if not "%Platform:Cafe=%"=="%Platform%" goto :cafe
if not "%Platform:NX=%"=="%Platform%" goto :nx

rem Assume Win32

if not "%Config:NX=%"=="%Config%" goto :nxonwin32

echo "Win32/GL shader"
%SdkRoot%\Tools\Graphics\GraphicsTools\ShaderConverter32.exe -o %OutName%_gl.grsf --platform Win --source-format Glsl --code-type Source --api-type Gl %1 %2 %3 %4 %5 %6 %7 %8 %9
goto :end

:nxonwin32
echo "NX on Win32 shader"
%SdkRoot%\Tools\Graphics\GraphicsTools\ShaderConverter32.exe -o %OutName%.grsf --platform Win --source-format Glsl --code-type Binary --api-type Nvn --reflection %1 %2 %3 %4 %5 %6 %7 %8 %9
goto :end

:nx
echo "NX on Horizon shader"
%SdkRoot%\Tools\Graphics\GraphicsTools\ShaderConverter32.exe -o %OutName%.grsf --platform Nx --source-format Glsl --code-type Binary --api-type Nvn --reflection %1 %2 %3 %4 %5 %6 %7 %8 %9
goto :end

:cafe
echo "Cafe shader"
%SdkRoot%\Tools\Graphics\GraphicsTools\ShaderConverter32.exe -o %OutName%.grsf --platform Cafe --source-format Glsl --code-type Binary --api-type Gx --reflection %1 %2 %3 %4 %5 %6 %7 %8 %9
goto :end

:end
echo Done
exit /b %ERRORLEVEL%
