﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nns/gfx0/gfx0_Driver.h>

#include "gfx0_DriverImpl.h"

namespace nns { namespace gfx0 {

namespace {

//-----------------------------------------------------------------------------
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct  Gfx0DriverByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, Gfx0DriverByHipcTag> Gfx0Allocator;

//-----------------------------------------------------------------------------
// Gfx0Allocator を静的コンストラクタで初期化するためのヘルパー
class Gfx0AllocatorInitializer
{
public:

    Gfx0AllocatorInitializer() NN_NOEXCEPT
    {
        Gfx0Allocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_Gfx0AllocatorInitializer;

}   // namespace

//-----------------------------------------------------------------------------
//  グラフィックドライバのサービスを DFC として初期化して使用可能にしま>す。
//
nn::sf::SharedPointer<IGfx0Driver> CreateGfx0DriverByDfc() NN_NOEXCEPT
{
    typedef nn::sf::ObjectFactory<Gfx0Allocator::Policy>    Factory;

    return Factory::CreateSharedEmplaced<IGfx0Driver, Gfx0DriverImpl>();
}

//-----------------------------------------------------------------------------

}}  // namespace nns::gfx0

