﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/dd.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/sf/sf_NativeHandle.h>

#include <nns/display0/display0_DriverShim.h>
#include <nns/display0/display0_Driver.h>


namespace nns { namespace display0 {

namespace {

//-----------------------------------------------------------------------------
// Shim ライブラリ実装用のサービスオブジェクトへの共有ポインタ
nn::sf::SharedPointer<IDisplay0Driver>  g_Display0Driver;

}   // namespace


//-----------------------------------------------------------------------------
//  ディスプレイドライバの処理を開始します。DFC 用です。
//
void InitializeDisplay0DriverByDfcForTest() NN_NOEXCEPT
{
    NN_SDK_ASSERT(!g_Display0Driver);

    g_Display0Driver = CreateDisplay0DriverByDfc();
}


//-----------------------------------------------------------------------------
//  ディスプレイドライバの処理を開始します。HIPC 用です。
//
void StartDisplay0(nn::os::SystemEventType* systemEvent) NN_NOEXCEPT
{
    NN_SDK_ASSERT(!g_Display0Driver);

    g_Display0Driver = CreateDisplay0DriverByHipc();

    auto handle = nn::os::DetachReadableHandleOfSystemEvent(systemEvent);
    g_Display0Driver->StartDisplay0( nn::sf::NativeHandle(handle, true) );
}


//-----------------------------------------------------------------------------
//  ディスプレイドライバの処理を停止します。
//
void StopDisplay0() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_Display0Driver);

    g_Display0Driver->StopDisplay0();
    g_Display0Driver = nullptr;
}


//-----------------------------------------------------------------------------

}} // namespace nns::display0

