﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>      // for nn::sf::ExpHeapStaticAllocator
#include <nns/display0/display0_IDisplay0Driver.sfdl.h>  // for IDisplay0Driver
#include <nns/display0/display0_Driver.h>            // for IDisplay0Driver
#include <nns/display0/display0_ServiceName.h>       // for IDisplay0Driver

#include "display0_DriverImpl.h"

namespace nns { namespace display0 {

namespace {

//-----------------------------------------------------------------------------
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct  Display0DriverByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, Display0DriverByHipcTag> Display0Allocator;

//-----------------------------------------------------------------------------
// Display0Allocator を静的コンストラクタで初期化するためのヘルパー
class Display0AllocatorInitializer
{
public:

    Display0AllocatorInitializer() NN_NOEXCEPT
    {
        Display0Allocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_Display0AllocatorInitializer;

}

//-----------------------------------------------------------------------------
//  グラフィックドライバのサービスを HIPC として初期化して使用可能にします。
//
nn::sf::SharedPointer<IDisplay0Driver> CreateDisplay0DriverByHipc() NN_NOEXCEPT
{
    // Display0DriverServiceName のサービス名で示される HIPC サービスオブジェクトを
    // IDisplay0Driver としてプロキシクライアントを作成して返します。
    // アロケーションポリシーとして Display0Allocator::Policy を渡している。
    nn::sf::SharedPointer<IDisplay0Driver> ret;
    auto result = nn::sf::CreateHipcProxyByName<IDisplay0Driver, Display0Allocator::Policy>(&ret, Display0DriverServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

//-----------------------------------------------------------------------------

}}  // namespace nns::display0

