﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>

#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/hid_Mouse.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nn_Allocator.h>

#include <nns/dbgui/dbgui_InterfaceInfo.h>

struct ImDrawData;

namespace nns { namespace dbgui { namespace io {

#if defined(NNS_DBGUI_ENABLE_SOFTWARE_KEYBOARD)
struct TextInputProperties
{
    const char*     pInitialText;
    bool            isMultiline;
};
#endif


struct ImguiIoInfo
{
    nn::AllocateFunctionWithUserData    pMemoryCallbackAllocate;
    nn::FreeFunctionWithUserData        pMemoryCallbackFree;
    void*                               pMemoryCallbackUserData;
    const void*                         pCustomFontBuffer;
    size_t                              customFontBufferSize;
    bool                                customFontIsCompressed;
    float                               customFontCharacterSize;
    int                                 displayWidth;
    int                                 displayHeight;
    const char*                         iniFilePath;
    const int*                          pNpadNavigationKeyBindings;
    const int*                          pDebugNpadNavigationKeyBindings;
    float                               mouseWheelScrollRatio;
};

void Initialize(const ImguiIoInfo* pInfo);
void Finalize();

bool IsMoveMouseRequested();
void GetMoveMouseRequestedPos(int* pPosX, int* pPosY);

void NewFrame(nn::TimeSpan frameDuration);
void Render();
ImDrawData* GetDrawData();

void SetupUserInputConfiguration();
void ResetPadNavigationInputs();;
void ResetMouseInputs();

void UpdateNavigationFromDebugPadState(
    const nn::hid::DebugPadButtonSet& debugPadButtonSet,
    const nn::hid::AnalogStickState& analogStickState,
    int32_t stickActivationThreshold);

void UpdateNavigationFromNpadState(
    const nn::hid::NpadButtonSet& buttons,
    const nn::hid::AnalogStickState& analogStick,
    int32_t stickActivationThreshold);

void UpdateKeyboardState(const nn::hid::KeyboardState& keyboardState);
void UpdateMouseState(const nn::hid::MouseState& mouseState);
void UpdateMouseStateFromTouchState(const nn::hid::TouchState& touchState);
void AddInputCharacter(char charToAdd);
void AddInputCharactersUtf8(const char* utf8CharsToAdd);

#if defined(NNS_DBGUI_ENABLE_SOFTWARE_KEYBOARD)
bool WantTextInput();
void BeginTextInput(TextInputProperties* pOutTextInputProperties);
bool FinishTextInput();
#endif

} } } // namespace nns { namespace dbgui { namespace io {
