﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

INOUT Varying
{
    vec2 texCoord;
    vec4 color;
} InOut;

layout(std140, binding = 0) uniform VertexUniform
{
    vec4 posScale;
};

#if VERTEX_SHADER

layout(location = 0) in vec2 i_Position;
layout(location = 1) in vec2 i_TexCoord;
layout(location = 2) in vec4 i_Color;


void main()
{
    gl_Position = vec4(
        (i_Position.x * posScale.x) + posScale.z,
        (i_Position.y * posScale.y) + posScale.w,
        0.5, 1);

    InOut.texCoord = i_TexCoord.xy;
    InOut.color = i_Color;
}

#endif


#if PIXEL_SHADER

layout(location = 0) out vec4 o_Color;

layout(binding = 0) uniform sampler2D tex;

void main()
{
    vec4 tex_color = texture(tex, InOut.texCoord);
    o_Color = InOut.color;
#if SRGB
    o_Color.r = pow(o_Color.r, 2.2);
    o_Color.g = pow(o_Color.g, 2.2);
    o_Color.b = pow(o_Color.b, 2.2);
    o_Color.a = pow(o_Color.a, 1/2.2);
#endif
    o_Color *= tex_color;
}

#endif
