﻿using System;
using System.Net;
using System.Net.Sockets;

namespace WowFunctionTestServer
{
    class ConnectedEventArgs : EventArgs
    {
        public readonly Client Client;

        public ConnectedEventArgs(Client client)
        {
            Client = client;
        }
    }

    class Server
    {
        public event EventHandler<ConnectedEventArgs> Connected;

        // コンストラクタ
        public Server(int port)
        {
            m_ServerPort = port;
            m_tcpkaIdle = 10;
            m_tcpkaInterval = 10;
            m_tcpkaCnt = 10;
        }

        // サーバーを開始
        public void Run()
        {
            m_ListenSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            m_ListenSocket.Bind(new IPEndPoint(IPAddress.Any, m_ServerPort));
            m_ListenSocket.Listen(5);

            m_ListenSocket.BeginAccept(AcceptCallback, null);
        }

        // サーバーを停止
        public void Stop()
        {
            m_ListenSocket.Close();
        }

        public void SetTcpKaParam(int idle, int interval, int count)
        {
            m_tcpkaIdle = idle;
            m_tcpkaInterval = interval;
            m_tcpkaCnt = count;
            Console.WriteLine("TCP KA IDLE:{0}\n", m_tcpkaIdle);
            Console.WriteLine("TCP KA INTERVAL:{0}\n", m_tcpkaInterval);
            Console.WriteLine("TCP KA COUNT:{0}\n", m_tcpkaCnt);
        }

        // 非同期 Accept のコールバック
        void AcceptCallback(IAsyncResult asyncResult)
        {
            Socket socket;
            try
            {
                socket = m_ListenSocket.EndAccept(asyncResult);
            }
            catch (ObjectDisposedException)
            {
                return;
            }
            m_ListenSocket.BeginAccept(AcceptCallback, null);

            Connected(this, new ConnectedEventArgs(new Client(socket, m_tcpkaIdle, m_tcpkaInterval, m_tcpkaCnt)));
        }

        int m_ServerPort;
        Socket m_ListenSocket;
        int m_tcpkaIdle;
        int m_tcpkaInterval;
        int m_tcpkaCnt;
    }
}
