﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ModelController.h"

namespace WlanTest {

void AddSelectorElement(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& value, const nn::TimeSpan& initialValue)
{
    sv->Add(NamedValue<nn::TimeSpan>(ToStringSimpleTimeSpan(value), value), value == initialValue);
}

void GenerateSelectableOnOffValue(SelectableValue<NamedValue<bool> >* sv, const bool& initialValue)
{
    NamedValue<bool> on ("On", true);
    NamedValue<bool> off ("Off", false);

    sv->Add(on, initialValue == on);
    sv->Add(off, initialValue == off);
}

void GenerateSelectableChannel(SelectableValue<NamedValue<int16_t> >* sv, const int16_t& initialValue)
{
    NamedValue<int16_t> ch1("1ch", nn::wlan::WirelessChannel_1ch);
    NamedValue<int16_t> ch2("2ch", nn::wlan::WirelessChannel_2ch);
    NamedValue<int16_t> ch3("3ch", nn::wlan::WirelessChannel_3ch);
    NamedValue<int16_t> ch4("4ch", nn::wlan::WirelessChannel_4ch);
    NamedValue<int16_t> ch5("5ch", nn::wlan::WirelessChannel_5ch);
    NamedValue<int16_t> ch6("6ch", nn::wlan::WirelessChannel_6ch);
    NamedValue<int16_t> ch7("7ch", nn::wlan::WirelessChannel_7ch);
    NamedValue<int16_t> ch8("8ch", nn::wlan::WirelessChannel_8ch);
    NamedValue<int16_t> ch9("9ch", nn::wlan::WirelessChannel_9ch);
    NamedValue<int16_t> ch10("10ch", nn::wlan::WirelessChannel_10ch);
    NamedValue<int16_t> ch11("11ch", nn::wlan::WirelessChannel_11ch);
    NamedValue<int16_t> ch12("12ch", nn::wlan::WirelessChannel_12ch);
    NamedValue<int16_t> ch13("13ch", nn::wlan::WirelessChannel_13ch);
    NamedValue<int16_t> ch36("36ch", nn::wlan::WirelessChannel_36ch);            //!< 5GHz W52(DFS不要)
    NamedValue<int16_t> ch40("40ch", nn::wlan::WirelessChannel_40ch);
    NamedValue<int16_t> ch44("44ch", nn::wlan::WirelessChannel_44ch);
    NamedValue<int16_t> ch48("48ch", nn::wlan::WirelessChannel_48ch);
    NamedValue<int16_t> ch52("52ch", nn::wlan::WirelessChannel_52ch);            //!< 5GHz W53(DFS必要)
    NamedValue<int16_t> ch56("56ch", nn::wlan::WirelessChannel_56ch);
    NamedValue<int16_t> ch60("60ch", nn::wlan::WirelessChannel_60ch);
    NamedValue<int16_t> ch64("64ch", nn::wlan::WirelessChannel_64ch);
    NamedValue<int16_t> ch100("100ch", nn::wlan::WirelessChannel_100ch);         //!< 5GHz W56(DFS必要)
    NamedValue<int16_t> ch104("104ch", nn::wlan::WirelessChannel_104ch);
    NamedValue<int16_t> ch108("108ch", nn::wlan::WirelessChannel_108ch);
    NamedValue<int16_t> ch112("112ch", nn::wlan::WirelessChannel_112ch);
    NamedValue<int16_t> ch116("116ch", nn::wlan::WirelessChannel_116ch);
    NamedValue<int16_t> ch120("120ch", nn::wlan::WirelessChannel_120ch);
    NamedValue<int16_t> ch124("124ch", nn::wlan::WirelessChannel_124ch);
    NamedValue<int16_t> ch128("128ch", nn::wlan::WirelessChannel_128ch);
    NamedValue<int16_t> ch132("132ch", nn::wlan::WirelessChannel_132ch);
    NamedValue<int16_t> ch136("136ch", nn::wlan::WirelessChannel_136ch);
    NamedValue<int16_t> ch140("140ch", nn::wlan::WirelessChannel_140ch);
    NamedValue<int16_t> ch144("144ch", nn::wlan::WirelessChannel_144ch);
    NamedValue<int16_t> ch149("149ch", nn::wlan::WirelessChannel_149ch);         //!< 5GHz W58
    NamedValue<int16_t> ch153("153ch", nn::wlan::WirelessChannel_153ch);
    NamedValue<int16_t> ch157("157ch", nn::wlan::WirelessChannel_157ch);
    NamedValue<int16_t> ch161("161ch", nn::wlan::WirelessChannel_161ch);
    NamedValue<int16_t> ch165("165ch", nn::wlan::WirelessChannel_165ch);
    sv->Add(ch1, initialValue == ch1);
    sv->Add(ch2, initialValue == ch2);
    sv->Add(ch3, initialValue == ch3);
    sv->Add(ch4, initialValue == ch4);
    sv->Add(ch5, initialValue == ch5);
    sv->Add(ch6, initialValue == ch6);
    sv->Add(ch7, initialValue == ch7);
    sv->Add(ch8, initialValue == ch8);
    sv->Add(ch9, initialValue == ch9);
    sv->Add(ch10, initialValue == ch10);
    sv->Add(ch11, initialValue == ch11);
    sv->Add(ch12, initialValue == ch12);
    sv->Add(ch13, initialValue == ch13);
    sv->Add(ch36, initialValue == ch36);
    sv->Add(ch40, initialValue == ch40);
    sv->Add(ch44, initialValue == ch44);
    sv->Add(ch48, initialValue == ch48);
    sv->Add(ch52, initialValue == ch52);
    sv->Add(ch56, initialValue == ch56);
    sv->Add(ch60, initialValue == ch60);
    sv->Add(ch64, initialValue == ch64);
    sv->Add(ch100, initialValue == ch100);
    sv->Add(ch104, initialValue == ch104);
    sv->Add(ch108, initialValue == ch108);
    sv->Add(ch112, initialValue == ch112);
    sv->Add(ch116, initialValue == ch116);
    sv->Add(ch120, initialValue == ch120);
    sv->Add(ch124, initialValue == ch124);
    sv->Add(ch128, initialValue == ch128);
    sv->Add(ch132, initialValue == ch132);
    sv->Add(ch136, initialValue == ch136);
    sv->Add(ch140, initialValue == ch140);
    sv->Add(ch144, initialValue == ch144);
    sv->Add(ch149, initialValue == ch149);
    sv->Add(ch153, initialValue == ch153);
    sv->Add(ch157, initialValue == ch157);
    sv->Add(ch161, initialValue == ch161);
    sv->Add(ch165, initialValue == ch165);
}

void GenerateSelectableSsid(SelectableValue<string>* sv, const string& initialValue)
{
    for(int i=1; i<=50; ++i)
    {
        string name = "wireless_test_" + to_string(i);
        sv->Add(name, initialValue == name);
    }
}

}
