﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include "Node.h"
#include "Counter.h"


namespace WlanTest {

/*!--------------------------------------------------------------------------*
  @brief        SAP端末クラス

 *---------------------------------------------------------------------------*/
class LocalNode : public Node
{
/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:

    bool               m_EnablePs;
    nn::os::Mutex      m_Cs;
    nn::os::ThreadType m_SendAfThread;

private:

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    virtual nn::Result Initialize();
    virtual nn::Result Finalize();

    virtual void StopMaintainConnection();

protected:

    virtual nn::Result WlanInitialize();
    virtual nn::Result WlanFinalize();
    // virtual nn::Result WlanOpenMode() = 0;
    // virtual nn::Result WlanCloseMode() = 0;
    virtual nn::Result WlanLocalCreateRxEntry(uint32_t* pRxId, const uint16_t pProtocols[], const int32_t& count, const int32_t& capacity);
    virtual nn::Result WlanSocketCreateRxEntry(uint32_t* pRxid, const uint16_t pProtocols[], const int32_t& count, const int32_t& capacity);
    virtual nn::Result WlanLocalCreateRxEntryForAf(uint32_t* pRxId, const uint16_t pProtocols[], const int32_t& count, const int32_t& capacity);
    virtual nn::Result WlanDetectCreateRxEntryForAf(uint32_t* pRxId, const uint16_t pProtocols[], const int32_t& count, const int32_t& capacity);
    virtual nn::Result WlanLocalDeleteRxEntry(uint32_t* pRxId);
    virtual nn::Result WlanSocketDeleteRxEntry(uint32_t* pRxId);
    virtual nn::Result WlanLocalDeleteRxEntryForAf(uint32_t* pRxId);
    virtual nn::Result WlanDetectDeleteRxEntryForAf(uint32_t* pRxId);
    virtual nn::Result WlanLocalAddMatchingData(const uint32_t& rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo);
    virtual nn::Result WlanLocalRemoveMatchingData(const uint32_t& rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo);

    virtual nn::Result WlanGetFrame( uint32_t rxId, uint8_t pOutput[], size_t* pSize, size_t maxSize, int8_t* pRssi = NULL );
    virtual nn::Result WlanPutFrame( const uint8_t pInput[], size_t size, bool selfCts = false );
    virtual nn::Result WlanGetActionFrame(nn::wlan::MacAddress* pOutSrcMac, uint8_t pOutBuf[], size_t size, size_t* pOutSize, uint32_t rxId, uint16_t* pChannel, int16_t* pRssi);
    virtual nn::Result WlanPutActionFrame(const nn::wlan::MacAddress& dstMac, const uint8_t* pData, size_t size, int16_t channel, uint32_t dwellTime);
    virtual nn::Result WlanGetState(nn::wlan::WlanState *pSta);

    virtual nn::Result WlanCancelGetFrame(uint32_t rxId);
    virtual nn::Result WlanCancelGetActionFrame(uint32_t rxId);

    virtual nn::Result CreateRxEntry();
    virtual nn::Result DeleteRxEntry();

    virtual bool IsAfRxReady();

private:

 /*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:
    LocalNode();
    virtual ~LocalNode();

    void SetEnablePs( bool b )
    {
        m_EnablePs = b;
    }

private:

/*---------------------------------------------------------------------------
　　　　　アクセッサ
---------------------------------------------------------------------------*/
public:
};


}
