﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <queue>

#include "WlanCommon.h"

namespace WlanTest {

/*!--------------------------------------------------------------------------*
  @brief        コマンドインタフェース

 *---------------------------------------------------------------------------*/
class Command
{
/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:
private:
    uint32_t      m_Number;
    uint32_t      m_Count;
    NN_PADDING3;
/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:
    void Invoke();

protected:
    virtual void CommandContent();

/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:
    Command();

private:

/*---------------------------------------------------------------------------
　　　　　アクセッサ
---------------------------------------------------------------------------*/
public:
    virtual size_t GetInstanceSize() const = 0;
    void SetNumber(uint32_t n);
    virtual bool NeedReinvoke();
};



/*!--------------------------------------------------------------------------*
  @brief        ログ表示コマンド

 *---------------------------------------------------------------------------*/
/*
class LogCommand : public Command
{
private:
    char m_String[32];

public:
    virtual void CommandContent()
    {
        NN_LOG("LogCommand : %s\n", m_String);
    }

    virtual size_t GetInstanceSize() const
    {
        return sizeof(LogCommand);
    }

    LogCommand(std::string str)
    {
        std::memcpy(m_String, str.c_str(), str.size() + 1);
    }
};
*/

/*!--------------------------------------------------------------------------*
  @brief        コマンド実行器

 *---------------------------------------------------------------------------*/
class Invoker
{
/*---------------------------------------------------------------------------
　　　　　静的変数
---------------------------------------------------------------------------*/
public:
protected:
private:
    static uint8_t m_sId;
    uint8_t m_Id;

    nn::os::ThreadType m_Thread;

/*---------------------------------------------------------------------------
　　　　　静的メソッド
---------------------------------------------------------------------------*/
public:
private:

    static void InvokeThreadFunction(void* invoker);

/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:

    bool                 m_Stop;
    NN_PADDING3;
    std::queue<Command*> m_CommandList;
    nn::os::Event        m_AddCommandEvent;

private:

    uint32_t             m_CommandLimit;
    uint32_t             m_Count;

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    nn::Result Start(int32_t priority = nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()));
    void Stop();
    virtual nn::Result AddCommand(const Command& command);
    virtual void Clear();

protected:
    virtual void InvokeCommands();

private:

/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:
    Invoker();
    virtual ~Invoker();

private:

/*---------------------------------------------------------------------------
　　　　　アクセッサ
---------------------------------------------------------------------------*/
public:
    uint32_t GetCount();
};


}
