﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Selector.h"
#include "UIControl.h"
#include "Value.h"

namespace WlanTest {

/*---------------------------------------------------------------------------
  BtFlightModeItem
---------------------------------------------------------------------------*/
class BtFlightModeItem : public SelectableConfigCommand<NamedValue<bool>>
{

public:

    BtFlightModeItem();
    virtual ~BtFlightModeItem();

    string GetTitleName();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:


private:

    void GenerateItems();

};

/*---------------------------------------------------------------------------
  LlrNotifyItem
---------------------------------------------------------------------------*/
class LlrNotifyItem : public SelectableConfigCommand<NamedValue<nn::btm::BdAddress>>
{

public:

    LlrNotifyItem();
    virtual ~LlrNotifyItem();

    string GetTitleName();
    void Update();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:


private:

    void GenerateItems();

};


/*---------------------------------------------------------------------------
  ContinuousLlrNotifyItem
---------------------------------------------------------------------------*/
class ContinuousLlrNotifyItem : public LlrNotifyItem
{

public:

    ContinuousLlrNotifyItem();
    virtual ~ContinuousLlrNotifyItem();

    string GetTitleName();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:

    bool m_IsRunning;
    bool m_RequestStop;

    void ContinuousLlrNotify();
    static void ContinuousLlrNotifyThreadFunc(void* item);

private:

    void GenerateItems();

};


/*---------------------------------------------------------------------------
  StartGamepadPairingItem
---------------------------------------------------------------------------*/
class StartGamepadPairingItem : public SelectableConfigCommand<string>
{

public:

    StartGamepadPairingItem();
    virtual ~StartGamepadPairingItem();

    string GetTitleName();
    void Update();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:


private:

    void GenerateItems();

};


/*---------------------------------------------------------------------------
  CancelGamepadPairingItem
---------------------------------------------------------------------------*/
class CancelGamepadPairingItem : public SelectableConfigCommand<string>
{

public:

    CancelGamepadPairingItem();
    virtual ~CancelGamepadPairingItem();

    string GetTitleName();
    void Update();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:


private:

    void GenerateItems();

};


/*---------------------------------------------------------------------------
  EnableSlotSavingItem
---------------------------------------------------------------------------*/
class EnableSlotSavingItem : public SelectableConfigCommand<NamedValue<bool>>
{

public:

    EnableSlotSavingItem();
    virtual ~EnableSlotSavingItem();

    string GetTitleName();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:


private:

    void GenerateItems();

};


/*---------------------------------------------------------------------------
  BtResetItem
---------------------------------------------------------------------------*/
class BtResetItem : public SelectableConfigCommand<string>
{

public:

    BtResetItem();
    virtual ~BtResetItem();

    string GetTitleName();
    virtual int Execute();
    virtual int Cancel();
    virtual int Reset();

protected:


private:

    void GenerateItems();

};


/*---------------------------------------------------------------------------
  ConfigurationPage
---------------------------------------------------------------------------*/

class ConfigurationPage : public Page
{
public:

    ConfigurationPage();
    ~ConfigurationPage();

    virtual void UpdateItems();
    virtual void ShowImpl(Display& display);
    virtual void InputPad(Pad& pad);

protected:

    CommandSelector m_Selector;

    virtual void GenerateComponents();

private:

    enum CommandState
    {
        CommandState_Ready = 0x0,
        CommandState_Executing,
        CommandState_Executed
    };

    int m_CommandResult;
    CommandState m_CommandState;

    nn::os::ThreadType m_ExecuteThread;

    BtFlightModeItem          m_BtFlightModeItem;
    LlrNotifyItem             m_LlrNotifyItem;
    ContinuousLlrNotifyItem   m_ContinuousLlrNotifyItem;
    StartGamepadPairingItem   m_StartGamepadPairingItem;
    CancelGamepadPairingItem  m_CancelGamepadPairingItem;
    EnableSlotSavingItem      m_EnableSlotSavingItem;
    BtResetItem               m_BtResetItem;

    Label m_ResultLabel;
    ActiveIndicator m_ActiveIndicator;

    void UpdateCommandResult();
    void Start(int32_t priority = nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()));
    void Stop();
    static void ExecuteThreadFunction(void* configurationPage);
    void ExecuteCommand();

};

}    // WlanTest
