﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"

// タイトル画面
class SceneMeasureAllCh : public BaseScene {
    enum Menu {
        Menu_ScanTime,
        Menu_ScanInterval,
        Menu_End
    };
    enum Page {
        Page_2gNoise,
        Page_2gTxop,
        Page_W52W53Noise,
        Page_W52W53Txop,
        Page_End
    };

public :
    explicit SceneMeasureAllCh(ISceneChanger* changer) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(GraphicTools* pTools) NN_NOEXCEPT override;
private :
    static void MeasureThreadFunc(void* arg) NN_NOEXCEPT;
    void Draw2gNoise(GraphicTools* pTools) NN_NOEXCEPT;
    void Draw2gTxop(GraphicTools* pTools) NN_NOEXCEPT;
    void DrawW52W53Noise(GraphicTools* pTools) NN_NOEXCEPT;
    void DrawW52W53Txop(GraphicTools* pTools) NN_NOEXCEPT;

private :
    struct DisplayStats {
        uint64_t noiseSum;
        uint64_t txopSum;
        uint64_t count;
        int currentMeterNoise;
        int currentMeterTxop;
    };

    nn::os::ThreadType m_thread;
    static bool m_exitFlag;
    static nn::wlan::ScanParameters m_scanParam;
    static int m_scanInterval;
    static nn::wlan::ChannelStats m_stats[nn::wlan::WirelessChannelsCountMax + 1];
    static DisplayStats m_dispStats[nn::wlan::WirelessChannelsCountMax + 1];
    static nn::os::MutexType m_mutex;

    int m_curMenu;
    static int m_curPage;
};
