﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/wlan/wlan_Types.h>
#include <nn/wlan/wlan_Ssid.h>

class WirelessData
{
public:
    struct PeriodicActionFrameParam {
        int contentsChangeInterval;  // ActionFrameの中身を変更する間隔(ms)
    };

protected:
    nn::wlan::Ssid m_ssid;
    int16_t m_channel;
    nn::wlan::Security m_security;
    nn::wlan::WlanIpv4Address m_ownIp;

    PeriodicActionFrameParam m_afParam;
    nn::wlan::MasterBssParameters m_bssParam;

public:
    virtual ~WirelessData() NN_NOEXCEPT {}
    virtual void SetScanResult(char* pData, size_t size) NN_NOEXCEPT = 0;
    virtual char* GetScanResult() NN_NOEXCEPT = 0;
    virtual void SetConnectionParam(nn::wlan::Ssid ssid, int16_t channel, nn::wlan::Security security, char* pw) NN_NOEXCEPT = 0;
    virtual void GetConnectionParam(nn::wlan::Ssid* ssid, int16_t* channel, nn::wlan::Security* security, char* pw) NN_NOEXCEPT = 0;
    virtual void SetOwnIp(nn::wlan::WlanIpv4Address ip) NN_NOEXCEPT = 0;
    virtual void GetOwnIp(nn::wlan::WlanIpv4Address* pIp) NN_NOEXCEPT = 0;
    virtual void SetMasterParam(nn::wlan::MasterBssParameters bssParam, PeriodicActionFrameParam afParam) NN_NOEXCEPT = 0;
    virtual void GetMasterParam(nn::wlan::MasterBssParameters* bssParam, PeriodicActionFrameParam* afParam) NN_NOEXCEPT = 0;
};
