﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Network.h"
#include <nn/nn_Log.h>
#include <nn/os/os_Tick.h>
#include <vector>


namespace ApConnectivityTest
{

// コンストラクタ
Network::ConnectNetworkTask::ConnectNetworkTask(const nn::nifm::NetworkProfileData& profile, bool mixedMode, bool permanentProfile, const std::function<void(bool, const nn::TimeSpan&)>& callback) :
        Task(TaskType_ConnectNetwork),
        m_Profile(profile),
        m_MixedMode(mixedMode),
        m_PermanentProfile(permanentProfile),
        m_Callback(callback)
{
}


// デストラクタ
Network::ConnectNetworkTask::~ConnectNetworkTask()
{
}


// ネットワーク接続処理
void Network::ConnectNetworkTask::Run()
{
    auto connection = new NifmConnection(m_Profile, m_MixedMode, m_PermanentProfile);

    auto requestBeginTick = nn::os::GetSystemTick();
    auto succeed = connection->Connect();
    auto requestEndTick = nn::os::GetSystemTick();

    if (succeed)
    {
        Network::GetInstance().m_pConnection = connection;
        Network::GetInstance().m_IsNifmConnection = true;
    }
    else
    {
        delete connection;
    }

    m_Callback(succeed, (requestEndTick - requestBeginTick).ToTimeSpan());
}


}
