﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "App.h"
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Tick.h>
#include <nn/os/os_ThreadApi.h>


namespace ApConnectivityTest
{

App* App::g_Instance = nullptr;

// コンストラクタ
App::App() :
        m_Exit(false),
        m_FpsCount(0),
        m_FpsCountTimerEvent(nn::os::EventClearMode_AutoClear)
{
    NN_ASSERT(g_Instance == nullptr);
    g_Instance = this;

    m_Ui.Initialize();
    m_Hid.Initialize();

    m_FpsCountTimerEvent.StartPeriodic(nn::TimeSpan::FromSeconds(1), nn::TimeSpan::FromSeconds(1));
}


// デストラクタ
App::~App()
{
    m_Hid.Finalize();
    m_Ui.Finalize();

    g_Instance = nullptr;
}


// アクセサ
UI::UI& App::GetUi()
{
    return g_Instance->m_Ui;
}


Hid& App::GetHid()
{
    return g_Instance->m_Hid;
}


// 終了フラグ立てる
void App::Exit()
{
    m_Exit = true;
}


// メインループ
void App::Run()
{
    while (!m_Exit)
    {
        auto beginTime = nn::os::GetSystemTick().ToTimeSpan().GetMicroSeconds();

        m_Hid.Refresh();
        m_Ui.Update();

        auto endTime = nn::os::GetSystemTick().ToTimeSpan().GetMicroSeconds();
        auto elapsedTime = endTime - beginTime;
        if (elapsedTime < 16667)
        {
            nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(16667 - elapsedTime));
        }

        ++m_FpsCount;
        if (m_FpsCountTimerEvent.TryWait())
        {
            //NN_LOG("%d fps\n", m_FpsCount);
            m_FpsCount = 0;
        }
    }
}

}
