﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <list>
#include <string>
#include <nn/util/util_Vector.h>
#include <nn/hid/hid_DebugPad.h>

namespace ApConnectivityTest {
namespace UI {

class Keyboard
{
private:
    struct Key
    {
        char m_Char;
        char m_ShiftChar;

        const char* m_Name;
        const char* m_ShiftName;

        nn::util::Float2 m_Position;
        nn::util::Float2 m_Size;

        const Key* m_pLeftKey;
        const Key* m_pUpKey;
        const Key* m_pRightKey;
        const Key* m_pBottomKey;
    };

    enum ShiftState
    {
        ShiftState_Off,
        ShiftState_On,
        ShiftState_OnLock
    };

public:
    class KeyMap
    {
    public:
        virtual ~KeyMap() {};

        virtual const Key* GetKeys() const = 0;
        virtual void SpecialKeyDown(Keyboard& keyboard, char key) = 0;
        virtual void SpecialKeyDown(Keyboard& keyboard) = 0;
    };

    class FullKeyKeyMap : public KeyMap
    {
    private:
        enum KeyMapType
        {
            KeyMapType_Jp,
            KeyMapType_Us,
        };

    public:
        FullKeyKeyMap();
        virtual ~FullKeyKeyMap();

        virtual const Key* GetKeys() const;
        virtual void SpecialKeyDown(Keyboard& keyboard, char key);
        virtual void SpecialKeyDown(Keyboard& keyboard);

    private:
        static const Key m_KeysJp[];
        static const Key m_KeysUs[];

        KeyMapType m_ActiveKeyMap;
    };

    class NumberKeyMap : public KeyMap
    {
    public:
        virtual ~NumberKeyMap();

        virtual const Key* GetKeys() const;
        virtual void SpecialKeyDown(Keyboard& keyboard, char key);
        virtual void SpecialKeyDown(Keyboard& keyboard);

    private:
        static const Key m_Keys[];
    };

public:
    Keyboard();
    virtual ~Keyboard();

    void Initialize(KeyMap* keyMap, const std::string& initialString, size_t minLength, size_t maxLength, const std::function<void(const std::string&)>& callback);

    void Draw();

    void OnKeyDown(const nn::hid::DebugPadButtonSet& button);
    void OnKeyUp(const nn::hid::DebugPadButtonSet& button);
    void OnKeyPress(const nn::hid::DebugPadButtonSet& button);

private:
    void MoveCalletLeft();
    void MoveCalletRight();
    void Input(char inputChar);
    void BackSpace();
    void Enter();
    void ToggleShift();

    Key* GetHitKey(int32_t x, int32_t y);

public:
    static FullKeyKeyMap KeyMap_FullKey;
    static NumberKeyMap  KeyMap_Number;

private:
    KeyMap* m_KeyMap;
    const Key* m_ActiveKey;
    float m_KeyboardHeight;

    size_t m_MinLength;
    size_t m_MaxLength;

    ShiftState m_ShiftState;

    std::string m_Str;
    int m_CalletPos;

    std::function<void(const std::string&)> m_Callback;
};

}
}
