﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Keyboard.h"


namespace ApConnectivityTest {
namespace UI {

const Keyboard::Key Keyboard::KeyMapJp[] =
{
    { '1'   , '!'   , { { {  0.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[13],                 nullptr, &Keyboard::KeyMapJp[ 1], &Keyboard::KeyMapJp[14] },
    { '2'   , '"'   , { { {  1.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 0],                 nullptr, &Keyboard::KeyMapJp[ 2], &Keyboard::KeyMapJp[15] },
    { '3'   , '#'   , { { {  2.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 1],                 nullptr, &Keyboard::KeyMapJp[ 3], &Keyboard::KeyMapJp[16] },
    { '4'   , '$'   , { { {  3.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 2],                 nullptr, &Keyboard::KeyMapJp[ 4], &Keyboard::KeyMapJp[17] },
    { '5'   , '%'   , { { {  4.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 3],                 nullptr, &Keyboard::KeyMapJp[ 5], &Keyboard::KeyMapJp[18] },
    { '6'   , '&'   , { { {  5.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 4],                 nullptr, &Keyboard::KeyMapJp[ 6], &Keyboard::KeyMapJp[19] },
    { '7'   , '\''  , { { {  6.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 5],                 nullptr, &Keyboard::KeyMapJp[ 7], &Keyboard::KeyMapJp[20] },
    { '8'   , '('   , { { {  7.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 6],                 nullptr, &Keyboard::KeyMapJp[ 8], &Keyboard::KeyMapJp[21] },
    { '9'   , ')'   , { { {  8.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 7],                 nullptr, &Keyboard::KeyMapJp[ 9], &Keyboard::KeyMapJp[22] },
    { '0'   , '\0'  , { { {  9.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 8],                 nullptr, &Keyboard::KeyMapJp[10], &Keyboard::KeyMapJp[23] },
    { '-'   , '='   , { { { 10.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[ 9],                 nullptr, &Keyboard::KeyMapJp[11], &Keyboard::KeyMapJp[24] },
    { '^'   , '~'   , { { { 11.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[10],                 nullptr, &Keyboard::KeyMapJp[12], &Keyboard::KeyMapJp[25] },
    { '\\'  , '|'   , { { { 12.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[11],                 nullptr, &Keyboard::KeyMapJp[13], &Keyboard::KeyMapJp[25] },
    { '\x81', '\x81', { { { 13.5f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[12],                 nullptr, &Keyboard::KeyMapJp[ 0], &Keyboard::KeyMapJp[26] },

    { 'q'   , 'Q'   , { { {  1.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[26], &Keyboard::KeyMapJp[ 0], &Keyboard::KeyMapJp[15], &Keyboard::KeyMapJp[27] },
    { 'w'   , 'W'   , { { {  2.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[14], &Keyboard::KeyMapJp[ 1], &Keyboard::KeyMapJp[16], &Keyboard::KeyMapJp[28] },
    { 'e'   , 'E'   , { { {  3.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[15], &Keyboard::KeyMapJp[ 2], &Keyboard::KeyMapJp[17], &Keyboard::KeyMapJp[29] },
    { 'r'   , 'R'   , { { {  4.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[16], &Keyboard::KeyMapJp[ 3], &Keyboard::KeyMapJp[18], &Keyboard::KeyMapJp[30] },
    { 't'   , 'T'   , { { {  5.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[17], &Keyboard::KeyMapJp[ 4], &Keyboard::KeyMapJp[19], &Keyboard::KeyMapJp[31] },
    { 'y'   , 'Y'   , { { {  6.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[18], &Keyboard::KeyMapJp[ 5], &Keyboard::KeyMapJp[20], &Keyboard::KeyMapJp[32] },
    { 'u'   , 'U'   , { { {  7.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[19], &Keyboard::KeyMapJp[ 6], &Keyboard::KeyMapJp[21], &Keyboard::KeyMapJp[33] },
    { 'i'   , 'I'   , { { {  8.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[20], &Keyboard::KeyMapJp[ 7], &Keyboard::KeyMapJp[22], &Keyboard::KeyMapJp[34] },
    { 'o'   , 'O'   , { { {  9.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[21], &Keyboard::KeyMapJp[ 8], &Keyboard::KeyMapJp[23], &Keyboard::KeyMapJp[35] },
    { 'p'   , 'P'   , { { { 10.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[22], &Keyboard::KeyMapJp[ 9], &Keyboard::KeyMapJp[24], &Keyboard::KeyMapJp[36] },
    { '@'   , '`'   , { { { 11.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[23], &Keyboard::KeyMapJp[10], &Keyboard::KeyMapJp[25], &Keyboard::KeyMapJp[37] },
    { '['   , '{'   , { { { 12.0f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[24], &Keyboard::KeyMapJp[11], &Keyboard::KeyMapJp[26], &Keyboard::KeyMapJp[38] },
    { '\x80', '\x80', { { { 13.25f , 1.5f } } }, { { { 1.5f , 1.0f } } }, &Keyboard::KeyMapJp[25], &Keyboard::KeyMapJp[13], &Keyboard::KeyMapJp[14], &Keyboard::KeyMapJp[39] },

    { 'a'   , 'A'   , { { {  1.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[39], &Keyboard::KeyMapJp[14], &Keyboard::KeyMapJp[28], &Keyboard::KeyMapJp[41] },
    { 's'   , 'S'   , { { {  2.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[27], &Keyboard::KeyMapJp[15], &Keyboard::KeyMapJp[29], &Keyboard::KeyMapJp[42] },
    { 'd'   , 'D'   , { { {  3.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[28], &Keyboard::KeyMapJp[16], &Keyboard::KeyMapJp[30], &Keyboard::KeyMapJp[43] },
    { 'f'   , 'F'   , { { {  4.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[29], &Keyboard::KeyMapJp[17], &Keyboard::KeyMapJp[31], &Keyboard::KeyMapJp[44] },
    { 'g'   , 'G'   , { { {  5.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[30], &Keyboard::KeyMapJp[18], &Keyboard::KeyMapJp[32], &Keyboard::KeyMapJp[45] },
    { 'h'   , 'H'   , { { {  6.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[31], &Keyboard::KeyMapJp[19], &Keyboard::KeyMapJp[33], &Keyboard::KeyMapJp[46] },
    { 'j'   , 'J'   , { { {  7.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[32], &Keyboard::KeyMapJp[20], &Keyboard::KeyMapJp[34], &Keyboard::KeyMapJp[47] },
    { 'k'   , 'K'   , { { {  8.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[33], &Keyboard::KeyMapJp[21], &Keyboard::KeyMapJp[35], &Keyboard::KeyMapJp[48] },
    { 'l'   , 'L'   , { { {  9.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[34], &Keyboard::KeyMapJp[22], &Keyboard::KeyMapJp[36], &Keyboard::KeyMapJp[49] },
    { ';'   , '+'   , { { { 10.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[35], &Keyboard::KeyMapJp[23], &Keyboard::KeyMapJp[37], &Keyboard::KeyMapJp[50] },
    { ':'   , '*'   , { { { 11.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[36], &Keyboard::KeyMapJp[24], &Keyboard::KeyMapJp[38], &Keyboard::KeyMapJp[51] },
    { ']'   , '}'   , { { { 12.25f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[37], &Keyboard::KeyMapJp[25], &Keyboard::KeyMapJp[39], &Keyboard::KeyMapJp[51] },
    { ' '   , ' '   , { { { 13.375f, 2.5f } } }, { { { 1.25f, 1.0f } } }, &Keyboard::KeyMapJp[38], &Keyboard::KeyMapJp[26], &Keyboard::KeyMapJp[27], &Keyboard::KeyMapJp[52] },

    { '\x83', '\x83', { { {  0.625f, 3.5f } } }, { { { 1.25f, 1.0f } } }, &Keyboard::KeyMapJp[52], &Keyboard::KeyMapJp[27], &Keyboard::KeyMapJp[41],                 nullptr },
    { 'z'   , 'Z'   , { { {  1.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[40], &Keyboard::KeyMapJp[27], &Keyboard::KeyMapJp[42],                 nullptr },
    { 'x'   , 'X'   , { { {  2.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[41], &Keyboard::KeyMapJp[28], &Keyboard::KeyMapJp[43],                 nullptr },
    { 'c'   , 'C'   , { { {  3.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[42], &Keyboard::KeyMapJp[29], &Keyboard::KeyMapJp[44],                 nullptr },
    { 'v'   , 'V'   , { { {  4.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[43], &Keyboard::KeyMapJp[30], &Keyboard::KeyMapJp[45],                 nullptr },
    { 'b'   , 'B'   , { { {  5.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[44], &Keyboard::KeyMapJp[31], &Keyboard::KeyMapJp[46],                 nullptr },
    { 'n'   , 'N'   , { { {  6.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[45], &Keyboard::KeyMapJp[32], &Keyboard::KeyMapJp[47],                 nullptr },
    { 'm'   , 'M'   , { { {  7.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[46], &Keyboard::KeyMapJp[33], &Keyboard::KeyMapJp[48],                 nullptr },
    { ','   , '<'   , { { {  8.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[47], &Keyboard::KeyMapJp[34], &Keyboard::KeyMapJp[49],                 nullptr },
    { '.'   , '>'   , { { {  9.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[48], &Keyboard::KeyMapJp[35], &Keyboard::KeyMapJp[50],                 nullptr },
    { '/'   , '?'   , { { { 10.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[49], &Keyboard::KeyMapJp[36], &Keyboard::KeyMapJp[51],                 nullptr },
    { '\\'  , '_'   , { { { 11.75f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapJp[50], &Keyboard::KeyMapJp[37], &Keyboard::KeyMapJp[52],                 nullptr },
    { '\x82', '\x82', { { { 13.125f, 3.5f } } }, { { { 1.75f, 1.0f } } }, &Keyboard::KeyMapJp[51], &Keyboard::KeyMapJp[39], &Keyboard::KeyMapJp[40],                 nullptr },
};

const size_t Keyboard::KeyMapJpCount = sizeof(Keyboard::KeyMapJp) / sizeof(*Keyboard::KeyMapJp);

const Keyboard::Key Keyboard::KeyMapUs[] =
{
    { '`'   , '~'   , { { {  0.25f , 0.5f } } }, { { { 0.5f , 1.0f } } }, &Keyboard::KeyMapUs[13],                 nullptr, &Keyboard::KeyMapUs[ 1], &Keyboard::KeyMapUs[27] },
    { '1'   , '!'   , { { {  1.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 0],                 nullptr, &Keyboard::KeyMapUs[ 2], &Keyboard::KeyMapUs[14] },
    { '2'   , '@'   , { { {  2.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 1],                 nullptr, &Keyboard::KeyMapUs[ 3], &Keyboard::KeyMapUs[15] },
    { '3'   , '#'   , { { {  3.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 2],                 nullptr, &Keyboard::KeyMapUs[ 4], &Keyboard::KeyMapUs[16] },
    { '4'   , '$'   , { { {  4.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 3],                 nullptr, &Keyboard::KeyMapUs[ 5], &Keyboard::KeyMapUs[17] },
    { '5'   , '%'   , { { {  5.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 4],                 nullptr, &Keyboard::KeyMapUs[ 6], &Keyboard::KeyMapUs[18] },
    { '6'   , '^'   , { { {  6.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 5],                 nullptr, &Keyboard::KeyMapUs[ 7], &Keyboard::KeyMapUs[19] },
    { '7'   , '&'   , { { {  7.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 6],                 nullptr, &Keyboard::KeyMapUs[ 8], &Keyboard::KeyMapUs[20] },
    { '8'   , '*'   , { { {  8.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 7],                 nullptr, &Keyboard::KeyMapUs[ 9], &Keyboard::KeyMapUs[21] },
    { '9'   , '('   , { { {  9.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 8],                 nullptr, &Keyboard::KeyMapUs[10], &Keyboard::KeyMapUs[22] },
    { '0'   , ')'   , { { { 10.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[ 9],                 nullptr, &Keyboard::KeyMapUs[11], &Keyboard::KeyMapUs[23] },
    { '-'   , '_'   , { { { 11.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[10],                 nullptr, &Keyboard::KeyMapUs[12], &Keyboard::KeyMapUs[24] },
    { '='   , '+'   , { { { 12.0f  , 0.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[11],                 nullptr, &Keyboard::KeyMapUs[13], &Keyboard::KeyMapUs[25] },
    { '\x81', '\x81', { { { 13.25f , 0.5f } } }, { { { 1.5f , 1.0f } } }, &Keyboard::KeyMapUs[12],                 nullptr, &Keyboard::KeyMapUs[ 0], &Keyboard::KeyMapUs[26] },

    { 'q'   , 'Q'   , { { {  1.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[26], &Keyboard::KeyMapUs[ 1], &Keyboard::KeyMapUs[15], &Keyboard::KeyMapUs[28] },
    { 'w'   , 'W'   , { { {  2.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[14], &Keyboard::KeyMapUs[ 2], &Keyboard::KeyMapUs[16], &Keyboard::KeyMapUs[29] },
    { 'e'   , 'E'   , { { {  3.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[15], &Keyboard::KeyMapUs[ 3], &Keyboard::KeyMapUs[17], &Keyboard::KeyMapUs[30] },
    { 'r'   , 'R'   , { { {  4.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[16], &Keyboard::KeyMapUs[ 4], &Keyboard::KeyMapUs[18], &Keyboard::KeyMapUs[31] },
    { 't'   , 'T'   , { { {  5.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[17], &Keyboard::KeyMapUs[ 5], &Keyboard::KeyMapUs[19], &Keyboard::KeyMapUs[32] },
    { 'y'   , 'Y'   , { { {  6.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[18], &Keyboard::KeyMapUs[ 6], &Keyboard::KeyMapUs[20], &Keyboard::KeyMapUs[33] },
    { 'u'   , 'U'   , { { {  7.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[19], &Keyboard::KeyMapUs[ 7], &Keyboard::KeyMapUs[21], &Keyboard::KeyMapUs[34] },
    { 'i'   , 'I'   , { { {  8.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[20], &Keyboard::KeyMapUs[ 8], &Keyboard::KeyMapUs[22], &Keyboard::KeyMapUs[35] },
    { 'o'   , 'O'   , { { {  9.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[21], &Keyboard::KeyMapUs[ 9], &Keyboard::KeyMapUs[23], &Keyboard::KeyMapUs[36] },
    { 'p'   , 'P'   , { { { 10.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[22], &Keyboard::KeyMapUs[10], &Keyboard::KeyMapUs[24], &Keyboard::KeyMapUs[37] },
    { '['   , '{'   , { { { 11.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[23], &Keyboard::KeyMapUs[11], &Keyboard::KeyMapUs[25], &Keyboard::KeyMapUs[38] },
    { ']'   , '}'   , { { { 12.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[24], &Keyboard::KeyMapUs[12], &Keyboard::KeyMapUs[26], &Keyboard::KeyMapUs[39] },
    { '\\'  , '|'   , { { { 13.5f  , 1.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[25], &Keyboard::KeyMapUs[13], &Keyboard::KeyMapUs[14], &Keyboard::KeyMapUs[39] },

    { ' '   , ' '   , { { {  0.625f, 2.5f } } }, { { { 1.25f, 1.0f } } }, &Keyboard::KeyMapUs[39], &Keyboard::KeyMapUs[ 0], &Keyboard::KeyMapUs[28], &Keyboard::KeyMapUs[40] },
    { 'a'   , 'A'   , { { {  1.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[27], &Keyboard::KeyMapUs[14], &Keyboard::KeyMapUs[29], &Keyboard::KeyMapUs[41] },
    { 's'   , 'S'   , { { {  2.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[28], &Keyboard::KeyMapUs[15], &Keyboard::KeyMapUs[30], &Keyboard::KeyMapUs[42] },
    { 'd'   , 'D'   , { { {  3.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[29], &Keyboard::KeyMapUs[16], &Keyboard::KeyMapUs[31], &Keyboard::KeyMapUs[43] },
    { 'f'   , 'F'   , { { {  4.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[30], &Keyboard::KeyMapUs[17], &Keyboard::KeyMapUs[32], &Keyboard::KeyMapUs[44] },
    { 'g'   , 'G'   , { { {  5.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[31], &Keyboard::KeyMapUs[18], &Keyboard::KeyMapUs[33], &Keyboard::KeyMapUs[45] },
    { 'h'   , 'H'   , { { {  6.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[32], &Keyboard::KeyMapUs[19], &Keyboard::KeyMapUs[34], &Keyboard::KeyMapUs[46] },
    { 'j'   , 'J'   , { { {  7.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[33], &Keyboard::KeyMapUs[20], &Keyboard::KeyMapUs[35], &Keyboard::KeyMapUs[47] },
    { 'k'   , 'K'   , { { {  8.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[34], &Keyboard::KeyMapUs[21], &Keyboard::KeyMapUs[36], &Keyboard::KeyMapUs[48] },
    { 'l'   , 'L'   , { { {  9.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[35], &Keyboard::KeyMapUs[22], &Keyboard::KeyMapUs[37], &Keyboard::KeyMapUs[49] },
    { ';'   , ':'   , { { { 10.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[36], &Keyboard::KeyMapUs[23], &Keyboard::KeyMapUs[38], &Keyboard::KeyMapUs[50] },
    { '\''  , '"'   , { { { 11.75f , 2.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[37], &Keyboard::KeyMapUs[24], &Keyboard::KeyMapUs[39], &Keyboard::KeyMapUs[50] },
    { '\x80', '\x80', { { { 13.125f, 2.5f } } }, { { { 1.75f, 1.0f } } }, &Keyboard::KeyMapUs[38], &Keyboard::KeyMapUs[26], &Keyboard::KeyMapUs[27], &Keyboard::KeyMapUs[51] },

    { '\x83', '\x83', { { {  0.875f, 3.5f } } }, { { { 1.75f, 1.0f } } }, &Keyboard::KeyMapUs[51], &Keyboard::KeyMapUs[27], &Keyboard::KeyMapUs[41],                 nullptr },
    { 'z'   , 'Z'   , { { {  2.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[40], &Keyboard::KeyMapUs[28], &Keyboard::KeyMapUs[42],                 nullptr },
    { 'x'   , 'X'   , { { {  3.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[41], &Keyboard::KeyMapUs[29], &Keyboard::KeyMapUs[43],                 nullptr },
    { 'c'   , 'C'   , { { {  4.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[42], &Keyboard::KeyMapUs[30], &Keyboard::KeyMapUs[44],                 nullptr },
    { 'v'   , 'V'   , { { {  5.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[43], &Keyboard::KeyMapUs[31], &Keyboard::KeyMapUs[45],                 nullptr },
    { 'b'   , 'B'   , { { {  6.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[44], &Keyboard::KeyMapUs[32], &Keyboard::KeyMapUs[46],                 nullptr },
    { 'n'   , 'N'   , { { {  7.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[45], &Keyboard::KeyMapUs[33], &Keyboard::KeyMapUs[47],                 nullptr },
    { 'm'   , 'M'   , { { {  8.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[46], &Keyboard::KeyMapUs[34], &Keyboard::KeyMapUs[48],                 nullptr },
    { ','   , '<'   , { { {  9.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[47], &Keyboard::KeyMapUs[35], &Keyboard::KeyMapUs[49],                 nullptr },
    { '.'   , '>'   , { { { 10.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[48], &Keyboard::KeyMapUs[36], &Keyboard::KeyMapUs[50],                 nullptr },
    { '/'   , '?'   , { { { 11.25f , 3.5f } } }, { { { 1.0f , 1.0f } } }, &Keyboard::KeyMapUs[49], &Keyboard::KeyMapUs[37], &Keyboard::KeyMapUs[51],                 nullptr },
    { '\x82', '\x82', { { { 12.875f, 3.5f } } }, { { { 2.25f, 1.0f } } }, &Keyboard::KeyMapUs[50], &Keyboard::KeyMapUs[39], &Keyboard::KeyMapUs[40],                 nullptr },
};

const size_t Keyboard::KeyMapUsCount = sizeof(Keyboard::KeyMapUs) / sizeof(*Keyboard::KeyMapUs);

}
}
