﻿var KEY_CODE_ENTER = 13;

var urlParams = (function() {
  var returnVal = {};
  var paramStrs = location.search.substring(1).split('&');
  paramStrs.forEach(function(item) {
    var kv = item.split('=');
    returnVal[kv[0]] = kv[1];
  });
  return returnVal;
}());

var data = {
  stage: urlParams.stage,
  course: urlParams.course - 0,
  car: urlParams.car - 0,
  player: urlParams.player - 0,
  ranking: (function(rankingStr) {
    var returnVal = [];
    var ranking = rankingStr.split('|');
    ranking.forEach(function(itemStr) {
      var item = itemStr.split(',');
      returnVal.push({
        driver: item[0].replace(/%20/, ' '),
        time: item[1],
      });
    });
    return returnVal;
  }(urlParams.ranking))
};

var courses = [
  {
    name: 'Greenhill Circuit',
    img: 'img/course_0.png',
    length: 5.251,
    laps: 5
  }
];

var cars = [
  {
    img: 'img/car_0.png'
  }
];

var sayings = [
  'Congratulations!!!',
  'Excellent!!',
  'Great!!',
  'Hang in there!',
  'Hang in there!',
  'Hang in there!',
  'Hang in there!',
];

var car = cars[data.car];
var course = courses[data.course];

document.querySelector('#car-img').style.backgroundImage = 'url(' + car.img + ')';
document.querySelector('#stage-num').textContent = data.stage;
document.querySelector('#course-name').textContent = course.name;
document.querySelector('#course-img').src = course.img;
document.querySelector('#course-length').textContent = course.length;
document.querySelector('#course-laps').textContent = course.laps;

data.ranking.forEach(function(item, index) {
  var tr = document.querySelector('.ranking tbody tr:nth-of-type(' + (index + 1) + ')');
  if (index === data.player) {
    tr.classList.add('is-player');
    document.querySelector('#saying').parentNode.dataset.rank = index + 1;
    document.querySelector('#saying').textContent = sayings[index];
  }
  tr.querySelector('td:nth-of-type(2)').textContent = item.driver;
  tr.querySelector('td:nth-of-type(3)').textContent = item.time;
});

document.querySelector('.ranking tbody tr:nth-of-type(1)').addEventListener('webkitAnimationEnd', function() {
  document.querySelector('.saying').classList.add('ready');
});

Array.prototype.forEach.call(document.querySelectorAll('.vertical-grad, .text'), function(item) {
  item.title = item.textContent;
});

document.addEventListener('keydown', function(event) {
  if (event.keyCode === KEY_CODE_ENTER) {
    if (window.nx && window.nx.playSystemSe) {
      window.nx.playSystemSe('SeWebButtonDecide');
    }
    location.href = 'http://localhost/';
  }
});

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  window.nx.footer.unsetAssign('B');
  window.nx.footer.unsetAssign('X');
}
