﻿var KEY = {
  ENTER: {
    CODE: 13,
    NAME: 'enter',
    PICT_CHAR: '&#xe056;'
  },
  LEFT: {
    CODE: 37,
    NAME: 'left',
    PICT_CHAR: '&#xe091;'
  },
  UP: {
    CODE: 38,
    NAME: 'up',
    PICT_CHAR: '&#xe092;'
  },
  RIGHT: {
    CODE: 39,
    NAME: 'right',
    PICT_CHAR: '&#xe090;'
  },
  DOWN: {
    CODE: 40,
    NAME: 'down',
    PICT_CHAR: '&#xe093;'
  }
};

var getKeyFromKeyCode = function(keyCode) {
  switch (event.keyCode) {
  case KEY.ENTER.CODE:
    return KEY.ENTER;
  case KEY.LEFT.CODE:
    return KEY.LEFT;
  case KEY.UP.CODE:
    return KEY.UP;
  case KEY.RIGHT.CODE:
    return KEY.RIGHT;
  case KEY.DOWN.CODE:
    return KEY.DOWN;
  }
  return null;
};

document.addEventListener('keydown', function(event) {
  var key = getKeyFromKeyCode(event.keyCode);
  if (!key) {
    return;
  }

  document.querySelector('[data-name="' + key.NAME + '"]').classList.add('hold');

  var logElem = document.querySelector('#log');
  var chars = logElem.querySelectorAll('span');
  if (chars.length >= 32) {
    logElem.removeChild(chars[chars.length - 1]);
  }
  var newChar = document.createElement('span');
  newChar.innerHTML = key.PICT_CHAR;
  logElem.insertBefore(newChar, logElem.firstChild);

  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebButtonDecide');
  }
});

document.addEventListener('keyup', function(event) {
  var key = getKeyFromKeyCode(event.keyCode);
  if (!key) {
    return;
  }

  document.querySelector('[data-name="' + key.NAME + '"]').classList.remove('hold');
});

document.addEventListener('touchstart', function() {
  Array.prototype.forEach.call(
    document.querySelectorAll('.hold'),
    function(elem) {
      elem.classList.remove('hold');
    }
  )
});
