﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Macro.h>

class IMenuItem;
class Controller;

class IMenu
{
public:
    IMenu() NN_NOEXCEPT;
    virtual ~IMenu() NN_NOEXCEPT;

    void Refresh() NN_NOEXCEPT;

    void Update(const Controller& input) NN_NOEXCEPT;
    void Render() const NN_NOEXCEPT;
protected:
    void Add(std::unique_ptr<IMenuItem>& item) NN_NOEXCEPT;

    virtual void RefreshItems() NN_NOEXCEPT = 0;
    virtual const char* GetName() const NN_NOEXCEPT = 0;
    virtual void RenderCurrentSetting() const NN_NOEXCEPT = 0;
private:
    typedef std::vector<std::unique_ptr<IMenuItem>> MenuItems;
    MenuItems m_Items;

    MenuItems::size_type m_CursorIndex;
};
