﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#define EnableGlobalWind    ( CHECK_CUSTOM_FIELD_FLAG( 0x1 ) )  // 風の影響を受ける
#define WindInfluence       ( ctm0.x )                          // 風の影響度

#define USE_USR_CUSTOM_FIELD
void AdjustmentStreamOutPosVec( inout vec3 outPos, inout vec3 outVec, inout float outParticleLife )
{
    // カスタムフィールドサンプル：グローバル風
    if( EnableGlobalWind )
    {
        // ゲーム内の風速をパーティクルの移動量に適用する。
        vec3 globalWindVec = vec3( 0.1, 0, 0 );
        outPos += globalWindVec * WindInfluence;
    }
    return;
}
