﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_MathTypes.h>

/// <?xml version="1.0" encoding="UTF-8"?>
/// <UserDataDefinition Kind="CustomAction"
///                     Name="Custom Action Sample"
///                     Version="0">
struct ResCustomActionSample
{
    /// <ParameterDefinition Name="フラグ"
    ///                      Type="CheckButtons"
    ///                      NeedReload="true">
    ///   <OptionGroup>
    ///     <Option BitIndex="0" UniqueKey="Option" Value="向きを初速方向に固定" Selected="false" />
    ///     <Option BitIndex="1" UniqueKey="EmitterGazing" Value="向きをエミッタ方向に固定" Selected="false" />
    ///     <Option BitIndex="2" UniqueKey="EmitterPulled" Value="エミッタに引っ張られる" Selected="false" />
    ///     <Option BitIndex="3" UniqueKey="ManualSwordBlur" Value="剣ブラー（手動）" Selected="false" />
    ///   </OptionGroup>
    unsigned int    choices;
    /// </ParameterDefinition>
    /// <ParameterDefinition Name="エミッタ方向を向く期間" Type="Slider1i">
    ///   <SliderSetting Default="60" Minimum="1" Maximum="1000000" Step="1" />
    unsigned int    gazingFrame;
    /// </ParameterDefinition>
    /// <ParameterDefinition Name="エミッタに引っ張られる期間" Type="Slider1i">
    ///   <SliderSetting Default="60" Minimum="1" Maximum="1000000" Step="1" />
    unsigned int    pulledFrame;
    /// </ParameterDefinition>
    /// <ParameterDefinition Name="引っ張り強度" Type="Slider1f">
    ///   <SliderSetting Default="0.001" Minimum="0" Maximum="1000000" Step="0.001" />
    float           pulledPower;
    /// </ParameterDefinition>
};

///   <UILayout>
///     <Group Name="内部向けカスタム機能: 機能のON/OFF">
///       <Parameter Member="choices" />
///     </Group>
///     <Group Name="向きを初速方向に固定: 要: 回転順序「ZXY」＆「XY平面のポリゴン」">
///     </Group>
///     <Group Name="向きをエミッタ方向に固定: 要: 回転順序「ZXY」＆「XY平面のポリゴン」">
///       <Parameter Member="gazingFrame" />
///     </Group>
///     <Group Name="エミッタに引っ張られる: 要: 回転順序「ZXY」＆「XY平面のポリゴン」">
///       <Parameter Member="pulledFrame" />
///       <Parameter Member="pulledPower" />
///     </Group>
///   </UILayout>
/// </UserDataDefinition>
