﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_MathTypes.h>

/// <?xml version="1.0" encoding="UTF-8"?>
/// <UserDataDefinition Kind="CustomShader"
///                     Name="Custom Shader Sample"
///                     Version="0">
///   <ParameterDefinition Name="ShaderFlags"
///                        Type="CheckButtons"
///                        BuiltInMember="Flags">
///     <OptionGroup>
///       <Option UniqueKey="change_color" Value="Change Color" />
///       <Option UniqueKey="change_position" Value="Change Position" />
///       <Option UniqueKey="simple_light" Value="Sample Light" />
///       <Option UniqueKey="check_normal" Value="Check Normal" />
///       <Option UniqueKey="normal_map" Value="NormalMap" />
///       <Option UniqueKey="simple_ibl" Value="SimpleIbl" />
///     </OptionGroup>
///   </ParameterDefinition>
struct ResCustomShaderSample
{
///   <ParameterDefinition Name="カラー"
///                        Type="ColorRgb">
///     <ColorSetting Default="1 0.7 0.5" />
    nn::util::Float3  color;
///   </ParameterDefinition>
///
///   <ParameterDefinition Name="加算する位置"
///                        Type="Slider3f">
///     <SliderSetting Default="0.0 10.0 0.0" Minimum="-1000000.0" Maximum="1000000.0" Step="0.1" />
    nn::util::Float3  pos;
///   </ParameterDefinition>

///   <ParameterDefinition Name="IBLカラー0"
///                        Type="ColorRgb">
///     <ColorSetting Default="0.3 1.0 1.0" />
    nn::util::Float3  iblColor0;
///   </ParameterDefinition>

///   <ParameterDefinition Name="IBLカラー1"
///                        Type="ColorRgb">
///     <ColorSetting Default="0.3 0.3 0.0" />
    nn::util::Float3  iblColor1;
///   </ParameterDefinition>
};
///   <UILayout>
///     <Group Name="シェーダーキー">
///       <Parameter Member="Flags" Comment="使用するカスタムシェーダの機能を選択します。この選択内容はシェーダーの実装分岐に使用されます。シェーダの実装は VfxCustomShader/Resources/CustomShader/Shader の内容を参照してください。" />
///     </Group>
///     <Group Name="パラメータ">
///       <Parameter Member="color" Comment="Change Color で使用する色を選択します。" />
///       <Parameter Member="pos" Comment="Change Position で使用する位置を選択します。" />
///       <Parameter Member="iblColor0" Comment="SimpleIbl で使用するグラデーションの上端色を選択します。" />
///       <Parameter Member="iblColor1" Comment="SimpleIbl で使用するグラデーションの下端色を選択します。" />
///     </Group>
///   </UILayout>
/// </UserDataDefinition>
