﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/os/os_Mutex.h>

#include "UserMigration_SequenceBase.h"

struct Mutex
{
    nn::os::MutexType _lock;
    void Lock() NN_NOEXCEPT
    {
        nn::os::LockMutex(&_lock);
    }
    void Unlock() NN_NOEXCEPT
    {
        nn::os::UnlockMutex(&_lock);
    }
    bool TryLock() NN_NOEXCEPT
    {
        return nn::os::TryLockMutex(&_lock);
    }
    bool IsLockedByCurrentThread() NN_NOEXCEPT
    {
        return nn::os::IsMutexLockedByCurrentThread(&_lock);
    }
};


class RootSequence final
    : public SequenceBase
{
public:
    enum class SceneKind
    {
        Start,
        ClientSequence,
        ServerSequence,
        Settings,
    };
    typedef SceneBase<SceneKind> SceneBase;

private:
    Window& m_Window;
    SceneKind m_CurrentScene;
    SceneKind m_NextScene;
    std::unique_ptr<SceneBase> m_Scene;
    std::unique_ptr<SequenceBase> m_SubSequence;

    void OnEntering(SceneKind next) NN_NOEXCEPT;

protected:
    virtual const Window::Components* GetCurrentSceneComponentsPtr() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void UpdateImpl() NN_NOEXCEPT NN_OVERRIDE;

public:
    explicit RootSequence(Window& window) NN_NOEXCEPT;
    virtual ~RootSequence() NN_NOEXCEPT NN_OVERRIDE;

    SequenceBase* GetSubSequence() NN_NOEXCEPT;
};
