﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/font.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include "Ui2dCommon.h"

//------------------------------------------------------------------------------
//
// カスタマイズしたシェーダを Ui2d ライブラリに読み込ませる処理です。
//
//------------------------------------------------------------------------------

// 初期化
void InitializeUserShader();

// 解放
void FinalizeUserShader();

// ユーザーシェーダーのコンスタントバッファ更新処理
void UpdateUserShaderConstantBuffers(const nn::ui2d::DrawInfo& drawInfo, nn::ui2d::Pane* pPane, void* pUserData);

// 計算処理
void CalculateUserShader();
