﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/spy/spy_Config.h>
#include <nn/spy/spy_SpyModule.h>
#include <nn/spy/spy_PlotFloat.h>

namespace nn { namespace spy {

class SpyController;

} }

//! @briefprivate
class SpySampleBModule : public ::nn::spy::SpyModule
{
    typedef ::nn::spy::SpyModule Base;

#if !defined(NN_BUILD_CONFIG_SPY_ENABLED)

public:
    NN_FORCEINLINE SpySampleBModule() NN_NOEXCEPT {}

    NN_FORCEINLINE void PushActorPosition(float x, float y) NN_NOEXCEPT
    {
        NN_UNUSED(x);
        NN_UNUSED(y);
    }

#else // NN_BUILD_CONFIG_SPY_ENABLED

public:
    //! @brief  コンストラクタです。
    SpySampleBModule() NN_NOEXCEPT;

    //! @brief  アクター位置を出力します。
    //!
    //! @return     成功したら true, 失敗したら false を返します。
    void PushActorPosition(float x, float y) NN_NOEXCEPT;

protected:
    virtual void OnRegistered() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUnregistered() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnSessionStarted() NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::spy::PlotFloat m_ActorPositionX;
    nn::spy::PlotFloat m_ActorPositionY;
#endif // NN_BUILD_CONFIG_SPY_ENABLED
};
