﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk.h>

// Atk を初期化します。
void InitializeAtk() NN_NOEXCEPT;

// Atk を終了します。
void FinalizeAtk() NN_NOEXCEPT;

// データをロードします。
void LoadAtkData() NN_NOEXCEPT;

// シーケンスサウンドを再生します。
bool StartAtkSequenceSound() NN_NOEXCEPT;

// ウェーブサウンドを再生します。
bool StartAtkWaveSound() NN_NOEXCEPT;

// ストリームサウンドを再生します。
bool StartAtkStreamSound() NN_NOEXCEPT;

// シーケンスサウンドを再生または継続します。
bool HoldAtkSequenceSound() NN_NOEXCEPT;

// ウェーブサウンドを再生または継続します。
bool HoldAtkWaveSound() NN_NOEXCEPT;

// ストリームサウンドを再生または継続します。
bool HoldAtkStreamSound() NN_NOEXCEPT;

// サウンドの再生を停止します。
void StopAtkSound() NN_NOEXCEPT;

// SoundArchivePlayer の更新処理を行います。
void UpdateAtkSoundArchivePlayer() NN_NOEXCEPT;

// SoundArchivePlayer を取得します。
nn::atk::SoundArchivePlayer& GetAtkSoundArchivePlayer() NN_NOEXCEPT;

// 波形データの読み出しに必要なバッファのサイズを取得します。
size_t GetCircularBufferSinkBufferSize() NN_NOEXCEPT;

// 波形データを読み出します。
size_t ReadCircularBufferSink(void* buffer, size_t bufferSize) NN_NOEXCEPT;
