﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/dd.h>

#if !defined( NN_BUILD_CONFIG_HARDWARE_JUNO )
    #error  "JUNO ボード向けのビルドではありません。"
#endif

namespace nns { namespace os { namespace interruptEvent {

//---------------------------------------------------------------------------

const int TimerInterruptName = 198;     // Interrupt Number for TIM01INT

// Physical address of SP810 timer register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x1c110000;
const size_t                  TimerRegisterRegionSize      = 0x00010000;

//  SP804 の Timer1 の TIMCLK は SP810 の SP810_CTRL レジスタの
//  TimerEn0Sel ビットの設定によって決まる。
//  デフォルトは 32KHz であり、その設定値をそのまま使う。
const int Sp804Timer1ClockFrequency     = 32 * 1000;    // 32KHz

//---------------------------------------------------------------------------

void ClearTimerInterruptStatus() NN_NOEXCEPT;
void StartTimerInterrupt() NN_NOEXCEPT;
void StopTimerInterrupt() NN_NOEXCEPT;

//---------------------------------------------------------------------------

}}} // namespace nns::os::interruptEvent

