﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{ShaderData.h,PageSampleNvnTutorial02}
 *
 * @brief
 *  This file defines a structure that hold output data from the
 *  shader compiler and structures that hold reflection data about
 *  the compiled shaders.
 */

#pragma once

#include <string>
#include <nvnTool/nvnTool_GlslcInterface.h>
#include <cstdint>
#include <vector>

struct ShaderCompileData
{
    std::string  m_Vert;
    std::string  m_Frag;
    std::string  m_Geom;
    std::string  m_TessCont;
    std::string  m_TessEval;
    std::string  m_Comp;
    GLSLCcompileObject m_CompileObject;
};

struct UniformData
{
    std::string      m_Name;
    GLSLCpiqTypeEnum m_Type;
    int32_t          m_BlockNdx;
    int32_t          m_BlockOffset;
    int32_t          m_Bindings[6];
    uint8_t          m_IsArray;
    uint32_t         m_SizeOfArray;
    uint32_t         m_ArrayStride;
    int32_t          m_MatrixStride;
    uint32_t         m_IsRowMajor;
    uint8_t          m_StagesReferencedIn;
};

struct UniformBlockData
{
    std::string m_Name;
    int32_t     m_Bindings[6];
    uint32_t    m_Size;
    uint32_t    m_NumActiveVariables;
    uint8_t     m_StagesReferencedIn;

    std::vector<UniformData> m_Uniforms;
};

struct VertexAttributeData
{
    std::string      m_Name;
    GLSLCpiqTypeEnum m_Type;
    uint8_t          m_IsArray;
    uint32_t         m_SizeOfArray;
    int32_t          m_Location;
    uint8_t          m_IsPerPatch;
    uint8_t          m_StagesReferencedIn;
};
