﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 /**
 * @examplesource{NifmNetworkConnectionSimple_ProgramBase.h,PageSampleNifmNetworkConnectionSimple}
 *
 * @brief
 */

#pragma once

#include <cstdarg>

#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

#include <nns/console/console_SimpleConsole.h>

template <class ProgramImpl>
class ProgramBase
    : public nns::console::SimpleConsole
{
protected:
    void Printf(const char* format, ...) NN_NOEXCEPT
    {
        char buffer[256];
        va_list args;
        va_start(args, format);
        auto l = nn::util::VSNPrintf(buffer, sizeof(buffer), format, args);
        va_end(args);

        if (l >= sizeof(buffer) - 1)
        {
            buffer[sizeof(buffer) - 1] = '\n';
        }
        nns::console::SimpleConsole::Puts(buffer);
        NN_LOG("%s", buffer);
    }

    // アプリケーションのメイン
    virtual void Execute() NN_NOEXCEPT = 0;

public:
    static void ThreadFunction(void* arg) NN_NOEXCEPT
    {
        reinterpret_cast<ProgramImpl*>(arg)->Execute();
    }
};
