﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "MediaPlayerObserver.h"
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <initializer_list>

static const nn::hid::NpadIdType npadIds[] = { nn::hid::NpadId::No1,
                                  nn::hid::NpadId::No2,
                                  nn::hid::NpadId::No3,
                                  nn::hid::NpadId::No4 };
static const int npadIdCount = NN_ARRAY_SIZE(npadIds);
static auto const playback_values = { 0.25f, 0.5f, 0.75f, 0.8f, 1.0f, 1.25f, 1.3f, 1.5f, 2.0f };
static auto const playback_1x = begin(playback_values) + 4;

class HidHandler
{
public:
    HidHandler(movie::BrowserPlayer* player, MediaPlayerObserver* mediaPlayerObserver, bool looping = false) :
        m_player(player),
        m_mediaPlayerObserver(mediaPlayerObserver),
        loop(looping) {}
    ~HidHandler() {}
    void Update();
    void Initialize();

private:
    movie::BrowserPlayer* m_player;
    MediaPlayerObserver* m_mediaPlayerObserver;
    nn::hid::DebugPadState debugPadState[nn::hid::DebugPadStateCountMax];
    nn::hid::NpadJoyDualState oldNpadJoyDualState[npadIdCount * 2];
    nn::hid::NpadJoyDualState currentNpadJoyDualState[npadIdCount * 2];
    int64_t prevPadSamplingNumber = 0;
    nn::hid::NpadButtonSet allCurrentNpadButtonsPressed;
    nn::hid::NpadButtonSet allCurrentNpadButtonsHeld;
    bool paused = false;
    bool loop;
    const float* current_playback_value = playback_1x;
    double playback_slide {0.0};
    int64_t lastSeekPosition {0};
};
