﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <movie/PlayerExtractor.h>
#include <movie/Extractor.h>
#include <movie/Utils.h>

#include <nn/nn_Assert.h>
#include <nn/nn_SdkLog.h>

#include <deque>
#include <vector>
#include <cinttypes>
#include <algorithm>

namespace movie { namespace sample {

class SimpleStream : public movie::ClientStreamReader {
    std::pair<char const*,int64_t> data_;
public:
    SimpleStream(char const* data, size_t len) noexcept
        : data_{data,static_cast<int64_t>(len)}
    {}
    bool Open(const char* s, void** p) override {
        *p = this;
        return true;
    }
    size_t ReadAt(void*, int64_t offset, void* data, size_t sz) override {
        if (offset >= data_.second) {
            return 0;
        }
        if (offset + sz >= data_.second) {
            sz = data_.second - offset;
        }
        memcpy(data, data_.first + offset, sz);
        return sz;
    }
    bool Close(void* p) override { return true; }
    void GetSize(void* p,int64_t* i) override {
        if (i) {
            *i = data_.second;
        }
    }
};

class ComposedStream : public movie::ClientStreamReader {
    std::pair<char const*,int64_t> prefix_;
    std::pair<char const*,int64_t> suffix_;
public:
    ComposedStream(char const* pre, size_t pre_len, char const* suf, size_t suf_len) noexcept
        : prefix_{pre,static_cast<int64_t>(pre_len)}
        , suffix_{suf,static_cast<int64_t>(suf_len)}
    {}
    bool Open(const char* s, void** p) override {
        *p = this;
        return true;
    }
    size_t ReadAt(void*, int64_t offset, void* data, size_t sz__) override {
        auto sz = static_cast<int64_t>(sz__);
        if (offset >= prefix_.second + suffix_.second) { // out of bounds
            return 0;
        }
        if (offset + sz >= prefix_.second + suffix_.second) {
            sz = (prefix_.second + suffix_.second) - offset; // shrink sz
        }
        char* dump = reinterpret_cast<char*>(data);
        int64_t pre_chunk_{}, suf_chunk_{};
        if (offset < prefix_.second) { // read from the prefix?
            pre_chunk_ = std::min<int64_t>(prefix_.second - offset, sz);
            memcpy(dump, prefix_.first + offset, pre_chunk_);
        }
        if (offset + sz > prefix_.second) { // read from the suffix?
            suf_chunk_ = sz - pre_chunk_;
            offset = std::max<int64_t>(prefix_.second, offset) - prefix_.second;
            memcpy(dump + pre_chunk_, suffix_.first + offset, sz - pre_chunk_);
        }
        return pre_chunk_ + suf_chunk_;
    }
    bool Close(void* p) override { return true; }
    void GetSize(void* p,int64_t* i) override {
        if (i) {
            *i = prefix_.second + suffix_.second;
        }
    }
};

}}
