﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define NN_LOG_USE_DEFAULT_LOCALE_CHARSET

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

namespace {

char g_MsCp932String[] = {
    '\x94', '\x43', '\x93', '\x56', '\x93', '\xB0', '\x8A', '\x4A',
    '\x94', '\xAD', '\x8A', '\xC2', '\x8B', '\xAB', '\x82', '\xD6',
    '\x82', '\xE6', '\x82', '\xA4', '\x82', '\xB1', '\x82', '\xBB',
    '\x81', '\x49', '\0'
}; // 任天堂開発環境へようこそ！

}

extern "C" void nninitStartup()
{
    NN_LOG("Log at %s (num=%d, ascii=%s, cp932=%s)\n",
        NN_CURRENT_FUNCTION_NAME, 123, "hello", g_MsCp932String);
    NN_PUT(g_MsCp932String, std::strlen(g_MsCp932String));
    NN_PUT("\n", 1);
}

extern "C" void nnMain()
{
    NN_LOG("Log at %s (num=%d, ascii=%s, cp932=%s)\n",
        NN_CURRENT_FUNCTION_NAME, 123, "hello", g_MsCp932String);
    NN_PUT(g_MsCp932String, std::strlen(g_MsCp932String));
    NN_PUT("\n", 1);
}
